# The Hubbard model: A computational perspective

Mingpu Qin $\mathbf { \lambda _ { 1 } }$ , Thomas Sch¨afer $^ { 2 }$ , Sabine Andergassen ${ \bf 3 }$ , Philippe Corboz $\mathbf { 4 }$ , and Emanuel Gull5

1Key Laboratory of Artificial Structures and Quantum Control, School of   
Physics and Astronomy, Shanghai Jiao Tong University, Shanghai, China, 200240   
2Max-Planck-Institut f¨ur Festk¨orperforschung, Heisenbergstraße 1, Stuttgart,   
Germany, 70569   
3Institut f¨ur Theoretische Physik and Center for Quantum Science, Universit¨at   
T¨ubingen, Germany, 72076   
4Institute for Theoretical Physics and Delta Institute for Theoretical Physics,   
University of Amsterdam, Amsterdam, The Netherlands, 1098 XH   
5University of Michigan, Ann Arbor, MI, USA, 48109

https://doi.org/10.1146/((please add article doi))

Copyright $©$ YYYY by Annual Reviews. All rights reserved

# Keywords

Hubbard Model, Model Hamiltonians, Strongly Correlated Electron Systems

# Abstract

The Hubbard model is the simplest model of interacting fermions on a lattice and is of similar importance to correlated electron physics as the Ising model is to statistical mechanics or the fruit fly to biomedical science. Despite its simplicity, the model exhibits an incredible wealth of phases, phase transitions, and exotic correlation phenomena. While analytical methods have provided a qualitative description of the model in certain limits, numerical tools have shown impressive progress in achieving quantitative accurate results over the last years. This article gives an introduction to the model, motivates common questions, and illustrates the progress that has been achieved over the last years in revealing various aspects of the correlation physics of the model.

# Contents

1. Introduction 1.1. Purpose and structure of this article 1.2. ‘Solving’ the Hubbard model 1.3. Connection of the model to experiments .   
2. Phase diagram and phase boundaries..   
3. The Hubbard model at half filling 3.1. The two-dimensional model at half filling . 3.2. The half-filled model in 3D   
4. The doped 2D Hubbard model at weak coupling 10 4.1. Magnetic and superconducting properties . 10 4.2. Weak-coupling pseudogap 10   
5. The doped 2D Hubbard model at intermediate-to-strong coupling . 1 1 5.1. Competition of low-energy ground states: uniform vs stripe states. 11 5.2. Pseudogap . 14 5.3. Superconductivity 16 5.4. Bad metal 17   
6. Towards the simulation of experimental probes 1 7 6.1. Angle-resolved photoemission spectroscopy 17 6.2. Optical conductivities . 18 6.3. Raman spectroscopy . 18 6.4. Magnetic response 18 Generalizations and extensions . 19 7.1. The 2D Hubbard model on other lattices 19 7.2. The attractive model. 20 7.3. Multi-orbital models. . 20 7.4. Models with non-local interactions 20 7.5. Non-equilibrium and driven system 21   
8. Conclusions and perspectives 21

# 1. Introduction

The Hubbard model is one of the simplest models of interacting fermions on a lattice. The model describes a fermion system with hopping term $t$ and interaction strength $U$ with Hamiltonian

$$
H = - t \sum _ { \langle i j \rangle \sigma } \left( \hat { c } _ { i \sigma } ^ { \dag } \hat { c } _ { j \sigma } + h . c . \right) + U \sum _ { i } \hat { n } _ { i \uparrow } \hat { n } _ { i \downarrow }
$$

where $_ i$ and $j$ denote sites on a lattice; $\sigma = \uparrow , \downarrow$ enumerates two spin species, $\hat { c }$ and $\hat { c } ^ { \dagger }$ annihilate and create particles, and $\hat { n } = \hat { c } ^ { \dagger } \hat { c }$ . Sometimes next-nearest neighbor hoppings $t ^ { \prime }$ are also included. Physical observables and phase diagrams are typically examined as a function of temperature, chemical potential (or, correspondingly, density), or (staggered) magnetic field. In this form, the model goes back to papers by Hubbard (110), Kanamori (130), and Gutzwiller (89). As already noted by these authors, the model is a sketch of nature in that it emphasizes electron correlation physics caused by local interactions in a single orbital, while phenomena due to non-local interactions, band structure, or effects between multiple orbitals are not directly contained.

![](images/09cb3384e94dc90cb7de19b3508dbfbcd3722084a1e91905425cf3fb11dad7c2.jpg)  
Figure 1   
(a) Graphical representation of the Hubbard model. Two of many proposed phase diagrams of the model at intermediate interaction strength, at finite (b) and zero temperature (c). Note (see Sec. 2) that (b) and (c) are mutually inconsistent, that in (b) charge ordered phases are missing and the precise location of phases and boundaries are hotly debated. In (c) the ground state in the large doped region is Fermi liquid-like with an instability towards pairing through the Kohn-Luttinger effect (33).

Despite these radical simplifications, the model has proven itself as a powerful tool for investigating correlated electron physics. On one hand, its relevance to cuprate physics has provided an early motivation for studying the model’s phase diagrams and ground states. On the other hand, its simplicity has made it an ideal target for early quantum simulators, where many-body phenomena can be investigated without the complication of many of the effects present in realistic condensed matter systems.

Theoretically, the presence of metallic, insulating, ferro- and antiferromagnetic, superconducting, and charge-ordered phases in a model with very few parameters has proven an appealing testbed for new analytical methods. However, it became apparent early on that the standard analytical toolkit of condensed matter theory was insufficient to describe this rich physics to the desired accuracy, and that sophisticated numerical methods would have to be used instead (83). This led to the development of a wide range of numerical tools based on many different approximations and approaches (152, 224), including diagonalization, diagrammatics, tensor network, variational, series expansion, Monte Carlo, and embedding methods. While different approaches often led to different answers in earlier years, the situation has significantly improved more recently. Thanks to algorithmic advances and an increase of computing power, several methods have started to reproduce consistent results, leading to a growing consensus on various aspects of the Hubbard model.

# 1.1. Purpose and structure of this article

In this article we review the recent progress in solving the Hubbard model from a computational perspective. We highlight results in which consensus has been reached among several numerical approaches and identify open challenges and their prospect of being resolved in

the future.

Countless papers have been published on the Hubbard model over the last 30 years. Inevitably, our list of references and our selection of topics can therefore not cover all of the important developments in this field. A good starting point for references to additional numerical works is given by earlier reviews (43, 20, 165, 254, 217, 218). An analytical perspective is provided in Ref. (7) in the same issue.

Our main focus is the single-band Hubbard model on the two-dimensional square lattice with interactions ranging from weak to intermediate and strong coupling. We also make connections to the $t$ - $J$ model and the Hubbard model in three dimensions. In the remainder of this introduction we define what we mean by ‘solving’ the model and discuss its connection to experiments. We will discuss the model in various parameter regimes, including broadly the ‘weak coupling’ regime, which for the purpose of this article denotes interaction strengths $U / t \lesssim 4$ (rather than the mathematical limit where weak coupling perturbation theory is exact), the ‘intermediate-coupling’ regime from $2 \lesssim U / t \lesssim 6$ , and the strong coupling regime for $U / t \gtrsim 6$ (which includes regions outside the applicability of an infinite- $U$ expansion).

We then review computational progress at half-filling (Sec. 3), before we consider the doped case at weak (Sec. 4) and intermediate to strong coupling (Sec. 5). Finally, we review the progress towards the simulation of experimental probes (Sec. 6). We only briefly discuss other lattice geometries, attractive interactions, multi-orbital systems, non-local interactions, and extensions for non-equilibrium and driven systems (Sec. 7). We conclude by giving perspectives and stating open questions (Sec. 8). To limit the scope of this article, we will also not discuss the bosonic version of this model, which has been studied extensively with cold atomic gas systems.

# 1.2. ‘Solving’ the Hubbard model

Despite its simple Hamiltonian, exact solutions of the Hubbard model only exist in special circumstances. Therefore, as a practical definition, we define as ‘solving’ the Hubbard model the task of obtaining results for a physically interesting observable to an accuracy that is comparable to or better than what is obtained in comparison calculations or experiment. Corresponding to the richness of the physics of the model, ‘solving’ the model can therefore have a very different meaning depending on the observable and parameter regime considered, and over time the questions of interest as well as the precision with which they have been answered have changed.

For instance, the question of whether there is $d _ { x ^ { 2 } - y ^ { 2 } }$ superconductivity in the Hubbard model at $U / t \sim 8$ and $1 / 8$ doping, which has been a major controversy for decades, has only been conclusively answered in recent years, when several methods confirmed that the ground state exhibits stripes but no superconductivity. While we consider this particular aspect as ‘solved’, there remains room for improvement on the quantitative level, such as higher accuracy on the magnitude of the stripe order.

It is frequently claimed, especially by works aiming to emulate the model in a quantum simulator or analog experiment, that the model is ‘exponentially hard’ due to the ‘negative fermion sign problem’ or the ‘exponential scaling of the Hilbert space’, and therefore not tractable in numerical studies. These statements are simplifications of the real challenge, which is that in order to obtain properties of the model, all methods, simulators, and emulators obtain a sequence of approximate solutions followed by an extrapolation to the exact limit. These may be finite-size extrapolations, extrapolations in the number of variational states kept, in diagram order, excitation level, final time for time-evolution, coherence time, and/or optical trap parameters. Many of these parameters are strongly linked to the physics occurring in a given parameter regime. Correspondingly, the quality and accuracy of all methods for the ‘solution’ of the model strongly depends on the parameter regime studied. In light of this it has been fruitful to establish ‘multi-method’ consensus solutions (152, 224), defined as solutions obtained with two or more methods with different underlying approximations, where results for the same quantity at the same set of parameters agree within method uncertainties. Figure 2 shows results from such benchmark projects.

![](images/4aec020f5bf1f65d527838f47bf7ad2fd1e707d4760ca11610ef52f7ad2f70ff.jpg)  
Figure 2   
Consensus plots from benchmark studies of the Hubbard model. (a) Energy of the doped 2D square lattice model at $U / t = 8$ as a function of temperature. Inset: Results for the ground - state energy (from (152)). (b) N´eel temperature of the half-filled model on a cubic lattice (central panel, reproduced with permission from APS (210) with work from (46, 242, 212, 136, 102, 146)). (c) Weak-coupling results for the temperature dependence of the magnetic correlation length $\xi$ in the half-filled model on a 2D square lattice ( $U / t = 2$ , (224)).

Collaborative benchmark projects have shown the value of obtaining results for the same parameters with multiple techniques. Even though several of the methods available are ‘controlled’ or ‘numerically exact’ in the sense that they converge to the exact result upon extrapolation in one or several parameters, this extrapolation is often difficult to perform in practice, or the methods are applied outside of the regime where the control parameters are small. Additionally, even though several techniques are ‘uncontrolled’ in the sense that there are residual errors that cannot be extrapolated away, those errors may not be large when compared to the corresponding extrapolation or statistical uncertainties in controlled methods, or the respective technique may be much better suited to a particular problem.

# 1.3. Connection of the model to experiments

1.3.1. Cuprate physics. Much of the interest in the Hubbard model in the intermediate to strong coupling regime stems from its relevance to the cuprate high-temperature superconductors discovered in the 1980s. Similar to experiments on these materials, Hubbard model simulations on the two-dimensional square lattice find regions of parameter space with $d _ { x ^ { 2 } - y ^ { 2 } }$ superconductivity, strong antiferromagnetic correlations, stripes, pseudogaps, Fermi liquid, and bad metallic behavior. Phase diagram lines and observables mirror many features of the experiment as a function of doping and temperature. However, it is difficult to make a precise correspondence between cuprate compounds and the single-orbital

Hubbard model.

Electronic structure simulations (3, 194, 304, 98, 97) and photoemission experiment (45) find bands with oxygen $p$ and copper $d$ character near the Fermi surface, necessitating a description with at least three orbitals (114). As Zhang and Rice argued (299), a superposition of oxygen and copper bands then yields an effective single orbital model. The parameters $t$ and $t ^ { \prime }$ can then be inferred by fitting the tight binding dispersion of a two-dimensional square lattice with next-nearest neighbor hopping to the ab-initio band structure, leading to $t ^ { \prime } / t$ ranging from $- 0 . 1$ to $- 0 . 4$ for most hole-doped cuprates (194, 174, 98, 97). Parameters can also be fitted to experiment. Fits to the photoemission signal (45) at the Fermi energy $E _ { F }$ result in $t ^ { \prime }$ values of the same order and interactions of $U / t \sim 8$ (138). Similarly, the interaction parameter can be extracted by fitting the spin-wave dispersion of the model to results from neutron experiments (38).

These fits are neither systematic nor controlled. Nevertheless, they all yield interaction parameters comparable to the bandwidth, $U / t \sim 8$ , and a small negative $t ^ { \prime } / t$ . A more accurate description of cuprate materials likely would include additional degrees of freedom such as multiple orbitals per site, non-local interactions, and additional non-local hopping terms.

Recent experiments on superconducting nickelate compounds have rekindled the interest in the high-temperature superconductivity aspect of the model (140). We also note that certain superconducting organic charge transfer salts may be described by a Hubbard model (200).

1.3.2. Quantum emulators and quantum computers. Due to the simplicity of the Hamiltonian, the richness of the physics, and the failure of analytical methods to provide adequate solutions, the fermionic Hubbard model is often chosen as a first target for analog quantum emulators (73). Hubbard quantum emulators aim to mimic the properties of the Hamiltonian by performing experimental measurements on a system that emulates the Hamiltonian. A wide range of emulators have been proposed, including (for the fermion model) ultracold atoms (175) and quantum dots (22, 233, 94). While these systems do not reach the predictive power of numerical simulations in equilibrium (152, 224), interesting results have been obtained for time-dependent phenomena (225, 273).

An alternative route to ‘quantum emulation’ is taken by early quantum computers (235). Here, one may hope that the simple interaction and hopping structure of the model may reduce complexity enough that quantum computers can provide solutions. While current calculations lag far behind the capabilities of classical computers (8), results for Hubbard models in interesting parameter regimes will likely become available long before quantum computing solutions of materials or chemistry problems are possible (272).

# 2. Phase diagram and phase boundaries

Not much is known about the precise phase diagram of the Hubbard model in two dimensions. While the ground-state phase diagram of the model at weak coupling is fairly well understood (49, 266), the phase diagram in the intermediate-to-strong interaction limit is hotly debated. Determining precise phase boundaries is hindered by the fact that the divergent correlation length at continuous phase transitions complicates finite size scaling; that several of competing phases have large and distinct unit cells; that energetic differences of competing phases are often minute; and that areas of phase space with very different physical properties are separated by broad crossovers, rather than sharp or first-order transitions. In addition, approximate methods tend to break symmetries and overemphasize ordered phases. For instance, while the Mermin-Wagner theorem (176) forbids magnetic order at non-zero temperature, most finite-size methods predict spurious magnetic phases that only disappear slowly in the limit of very large systems (170).

Correspondingly, while a broad consensus exists on the phases and their approximate locations, the precise shape of the transition lines is often not known. Visual representations such as the one in Fig. 1 therefore either correspond to the results within a given approximation, or are inspired by comparisons to simple theories or experimental target systems.

The presence of so many orders and phenomena has led to the term ‘intertwined orders’ (66), which is used in this context to express the fact that very many different orders and phenomena either coexist in the same phase, or are otherwise very close in energy or parameter space, making it difficult to pinpoint the exact location and properties of each phase.

In the following, we will discuss some of these phases and their locations in parameter space. Numerous additional and exotic phases, including nematic phases, have been proposed for the Hubbard model. Ref. (7) provides an overview and discusses some of these phases in more detail.

# 3. The Hubbard model at half filling

# 3.1. The two-dimensional model at half filling

The fermion sign problem is absent in Monte Carlo simulations of the half-filled Hubbard model on bipartite lattices (99). This makes efficient QMC simulations on large lattices possible, either by directly simulating finite size systems or by embedding cluster impurity problems with quantum embedding methods (165). Both results can then be extrapolated to the exact thermodynamic limit. Precise results are also available from other methods, see e.g. Refs. (152, 224) for an overview of many physical quantities from a wide range of numerical methods.

3.1.1. Static quantities: energies, entropies, and spatial correlation functions. The main static quantities of interest are ground-state and finite-temperature expectation values of energies, entropies, as well as spin and charge correlation functions. These quantities have been computed with a multitude of methods, and we summarize just a small selection of the results available.

Early finite lattice QMC results for antiferromagnetic order parameters and energies for different $U$ are presented in (101, 284), a thorough study of magnetic properties on large systems was performed in (259), and a list of ground state energies from the diagonalization of $4 \times 4$ systems at various interaction strengths and for different electron numbers can be found in (44). More recently, ground state energies, double occupancies and antiferromagnetic order parameters for different interactions extrapolated to the thermodynamic limit were presented in (205), calculated from a finite-size scaling analysis with twist averaged boundary conditions. This work also tabulates finite-size data from $4 \times 4$ to $1 6 \times 1 6$ systems for different boundary conditions.

Short-range correlation functions at half filling were calculated by QMC in (206) and finite temperature results can be found in (259). In (137), spin and charge correlations

DiagMC:   
diagrammatic Monte   
Carlo (203)

AF: antiferromagnetic

at finite temperature for $U / t \leq 4$ are calculated in a complementary DiagMC approach. Entropy and specific heat for the same approach (also for the doped case) can be found in (154). In the weak-coupling regime, the magnetic correlation length $\xi$ grows exponentially when lowering the temperature, see right panel of Fig. 2 (27, 284, 181, 221, 211, 224). Eventually, these long-range fluctuations are responsible for the destruction of magnetic ordering (Mermin-Wagner theorem (176)) and the development of a weak-coupling pseudogap (see Secs. 3.1.3 and 4.2) when approaching the (AF ordered) ground state from finite $T$ .

DMRG: density   
matrix   
renormalization   
group (274)   
MPS: matrix   
product state (226)   
DMFT: dynamical   
mean-field theory   
(71)

3.1.2. Dynamical quantities: spectral functions. The calculation of dynamical (i.e. frequency-dependent) results is considerably more challenging than the calculation of static observables.

Monte Carlo methods formulated in imaginary time or Matsubara frequency provide dynamical quantities, such as single and two-particle spectral functions, via analytic continuation (122) (see (99) for gap extraction at half filling). This continuation is ill conditioned and introduces additional uncertainty into the spectra even at half filling, where the sign problem is absent. In contrast, tensor network methods usually rely on a real-time evolution of the Hamiltonian, which avoids continuation but is limited by the growth of the entanglement with time, requiring increasingly large bond dimension. Alternatively, excitation spectra can also be obtained based on a tensor network excitation ansatz (257).

In the half-filled Hubbard model on the square lattice, QMC results for single particle gaps at $U / t = 4$ were calculated in (70, 10). In (263), single particle gaps for different interactions were obtained in the thermodynamic limit by a careful finite size analysis, establishing the presence of a gap for all interactions with an exponential decay in the small $U$ limit and linear scaling for large $U$ (263).

Complementary results are provided by tensor network methods. In Ref. (293), the spectral function was obtained using time dependent DMRG as a solver in cluster perturbation theory for clusters up to $2 \times 8 0$ , which was found to be in agreement with earlier QMC results (21, 202, 201, 76), but with a higher resolution. Time-dependent MPS calculations of spectral functions on 4-leg and 6-leg cylinders have so far only been obtained for the $t$ - $J$ model (17). In (257) results for the excitation gaps for $U / t = 1 2$ was obtained based on an MPS excitation ansatz on 4-leg and 8-leg infinite cylinders.

Resolving the full frequency and momentum dependence of the spectral function in the Brillouin zone is a difficult outstanding problem. Results from cluster DMFT are available at selected momentum points or averaged over small areas in momentum space, see e.g. (161), but extracting the detailed momentum-dependence and Fermi surface shape yields results that strongly depend on the periodization schemes employed (141).

3.1.3. Nature of the gap. The ground state of the two-dimensional Hubbard model on a square lattice with $t ^ { \prime } { = } 0$ is insulating, i.e. has a charge gap for any interaction strength $U$ (99, 284, 221, 263, 265). AF N´eel order (101, 259) persists for all interaction strengths.

In the strong interaction limit, the gap is of the Mott type (182) and the low energy physics is described by an effective spin- $1 / 2$ Heisenberg model with coupling constant $J = 4 t ^ { 2 } / U$ (5). The origin of the gap in the weak interaction region was controversial, and Ref. (4) argued that the gap in the weak interaction limit remains Mott. A complementary view is provided by the Slater mechanism (234), where the gap is formed by the establishment of long-range N´eel order due to the perfect nesting of the Fermi surface.

A diagnostic is provided by the evolution of the potential and kinetic energies as a function of interaction and temperature. In a Mott system, the transition to the insulator is accompanied by a lowering of the kinetic energy, whereas the Slater mechanism lowers the potential energy (87, 211). While early DCA calculations (183) supported Mott, later Refs. (87, 221, 211, 137) found a decrease of the potential energy in the weak coupling region, supporting a Slater mechanism. Despite the differing origins of the gap in the weak and strong coupling region, no phase transition between the two regimes is observed, indicating a crossover near $U / t \approx 4$ (263, 137), which agrees with the properties of the underlying ground state (18).

The evolution of the gap size and AF correlation length with temperature is difficult to study in numerical simulations, even where the sign problem is absent, as the spin correlation length grows exponentially when temperature is decreased. Rich physics is found in this process: upon cooling towards the insulating AF ground-state, a sequence of crossovers between a high-temperature incoherent regime, an intermediate metallic regime with coherent quasiparticles, and a low-temperature insulating regime with an AF pseudogap (221, 265, 137) is observed in DΓA, QMC and DiagMC. Due to the increased scattering rate at low $T$ , the inverse quasiparticle lifetime (extracted from Matsubara data) shows a minimum as a function of temperature (211, 223). Results for further observables from different methods at weak coupling can be found in (224).

# 3.2. The half-filled model in 3D

For all interaction strengths, the half-filled model with $t ^ { \prime } { = } 0$ in 3D exhibits a phase transition from a paramagnetic state at high $T$ to an AF insulator at low $T$ . The maximum transition temperature of $T _ { N } / t \sim 0 . 3 5$ occurs near $U / t \sim 8$ , remains large in the interval of $7 < U / t < 1 0$ , and decays rapidly both for weak and for strong coupling (220, 242, 136, 212, 210) (see central panel of Fig. 2). In addition to the AF phase transition, the system also exhibits a crossover identified either by a change in the compressibility or in the density of states at the Fermi energy near $U / t \sim 6 - 8$ (242, 69) between metallic (at weak coupling) and insulating (at strong coupling) behavior in the high-temperature phase.

Lattice Monte Carlo methods (16) and cluster quantum impurity solvers (84) do not suffer from a sign problem and accurate results for the system are available for all interaction strengths (136, 190, 146). The accurate treatment of the continuous phase transition requires considerable care due to the divergent length scale of fluctuations at the phase transition, and the transition has therefore been used as a rigorous test for diagrammatic extensions of the DMFT (212, 102, 210) and for finite size effects in cluster methods (136, 68, 146). Critical exponents have been studied with diagrammatic extensions of DMFT (212, 102, 222) and, within those approximations, are compatible with Heisenberg universality for all interaction strengths.

The three-dimensional system is of particular interest in the context of cold Fermi gases (120, 60), where cooling towards an ordered state in three dimensions proved less challenging than probing two-dimensional superconducting and antiferromagnetic correlations, mainly due to the high critical temperature of the model. Entropy, rather than temperature, is conserved in closed traps, and the highest critical entropy of $S \sim 0 . 6 5$ lies near $U \sim 8 t$ (68). Entropies of 0.77 were reached in (129); AF correlations were observed in (75, 91), and lattice cold atom experiments have since steadily increased the accessible parameter space (115).

DΓA: dynamical vertex approximation (210)

KT: Kosterlitz-Thouless

# 4. The doped 2D Hubbard model at weak coupling

# 4.1. Magnetic and superconducting properties

The ground state phase diagram reveals a rich behavior as a function of the different parameters. In addition to AF N´eel order, magnetic order with generally incommensurate wave vectors away from the N´eel point $( \pi , \pi )$ can be found away from half-filling in mean-field studies (227, 52, 67, 117) and, including fluctuations, by expansions in the hole-density (231, 34, 35, 145). Incommensurate magnetic order is also indicated by diverging interactions and susceptibilities in fRG flows (90, 113, 178), where approximate solutions indicate robust magnetic order up to fairly high doping provided that superconductivity is suppressed (290).

While the magnetic instability in the Hubbard model is reproduced already by conventional mean-field theory, pairing is fluctuation-driven and hence more difficult to capture. Simple qualitative arguments suggesting d-wave pairing driven by magnetic fluctuations were corroborated by the fluctuation exchange approximation (216). Convincing evidence for superconductivity at weak and moderate coupling strengths has been established by selfconsistent or renormalized perturbation expansions (15, 185, 150, 208), DiagMC (49, 267) and from fRG calculations (296, 90, 105, 104, 178, 54). With its unbiased treatment of all fluctuation channels on equal footing, the fRG confirmed earlier studies based on the summation of certain perturbative contributions (218), finding d-wave superconductivity with a sizable gap for a finite next-nearest neighbor hopping amplitude (54) coexisting with N´eel or incommensurate antiferromagnetism in a broad doping range (209, 268, 290). When the chemical potential approaches the van Hove singularity, different instabilities compete: besides spin density wave and pairing instabilities, ferromagnetism has been observed at moderate $\left| t ^ { \prime } / t \right|$ (119, 103, 104, 134, 185, 208). At finite temperature, computing the KT transition temperature from the superfluid phase stiffness, a superconducting dome centered around optimal doping has been found (260). Recently, fRG flows starting from the DMFT solution instead of the bare action (DMF $^ { 1 2 }$ RG) (246, 261) confirmed robust pairing with d-wave symmetry at strong coupling, driven by magnetic correlations at the edge of the antiferromagnetic regime.

# 4.2. Weak-coupling pseudogap

The term ‘pseudogap’ refers to a momentum-dependent suppression of the single-particle spectral function near the Fermi energy. In contrast to the pseudogap originating from strong coupling effects (see Sec. 5.2), at weak to intermediate coupling the pseudogap is induced by long-range antiferromagnetic correlations (262, 18, 148, 288, 224). The gap opens when the correlation length exceeds the thermal de Broglie wavelength $\xi \gg v _ { F } / ( \pi T )$ , where $_ { U F }$ is the Fermi velocity (262). The phenomenon has been studied within the two-particle self-consistent approach approximation (262), the DΓA (221), the dual-fermion approach (163), the parquet approximation (55), the DiagMC (265), and the fRG (95).

The underlying mechanism can be understood already from the second-order contribution of the self-energy: using the Ornstein-Zernike form for the spin susceptibility, it predicts a spectral gap for momenta close to the hot spots where the Fermi surface crosses the magnetic Brillouin zone boundary (262, 287). Upon lowering the temperature, the gap opens first near $( \pi , 0 )$ (the so-called antinode), then spreads across the Fermi surface until also the region near $( \pi / 2 , \pi / 2 )$ (the so-called node) becomes insulating. While a momentum-selective gap opening due to long-range antiferromagnetic spin fluctuations has been observed also at electron doping (148, 228, 254), most studies focus on models with a finite next-nearest-neighbor hopping $t ^ { \prime }$ which show a non-Fermi liquid behavior of the selfenergy at hole doping. In the weak-coupling regime, there is a natural connection between the Fermi surface topology and the coherence of low-energy quasiparticles: for a hole-like Fermi surface, the coherence of low-energy quasiparticles is suppressed at the hot spots. When the Fermi surface turns electron-like, increased quasiparticle coherence is restored all along the Fermi surface. The pseudogap only exists when the Fermi surface is hole-like. Hence, the Lifshitz transition from hole- to electron-like topology controls both the location of the self-energy singularities and the topological transition of the Fermi surface.

# 5. The doped 2D Hubbard model at intermediate-to-strong coupling

# 5.1. Competition of low-energy ground states: uniform vs stripe states

A striking feature of the doped 2D Hubbard model at strong coupling as well as of the $t$ - $J$ model is that they exhibit several competing ground states which lie very close in energy. This includes, on the one hand, a uniform d-wave superconducting state (see Refs. (43, 20, 165, 254, 217) for a review of early results) sometimes coexisting with antiferromagnetic order at low doping, on the other hand various inhomogeneous states in which charge and/or spin densities are modulated, called stripes (see Refs. (264, 66, 142, 1) for reviews). Experimentally, stripe order was also observed in some cuprate materials (253) in the under-doped region. In early Hartree-Fock studies, stripes were found to be insulating with a filling of exactly one hole per unit length (295, 197), whereas later it was found that stripes may also exhibit a different hole density (276, 277, 280) with coexisting d-wave superconductivity (278, 96, 281, 40, 39, 302). A more complex variant of the stripe, called a PDW state (1), includes a $\pi$ phase shift in the superconducting order between neighboring stripes, such that d-wave superconductivity vanishes on average. The PDW state was proposed in Ref. (13) as a possible explanation for the suppressed superconductivity observed in LBCO around $\delta = 1 / 8$ doping (155), and was found to be energetically very close to the stripe without phase shift (96, 207, 39).

Due to this strong competition it has been an open question for many years whether the ground state is a uniform d-wave or a stripe state (with possible coexisting superconductivity). Initially, the former was supported particularly by many VMC studies (294, 77, 74, 238, 57, 179, 250) and (cluster) DMFT studies (158, 90, 170, 23). A common opinion was that the stripes found with DMRG could be an artifact of the cylinder geometry, and that they would not be stable in isotropic, periodic systems (which are difficult to study with DMRG). This viewpoint was supported by a VMC study (12) where it was shown that a lattice anisotropy indeed leads to (spin) stripe correlations, and also by Ref. (106) where no stable stripe state was obtained in the $t$ - $J$ model, even when adding a (period 4) stripe bias and combining VMC with fixed-node MC and Lanczos steps. On the other hand, stripe states were found with iPEPS in the 2D thermodynamic limit (40) in the $t$ - $J$ model, which are energetically lower, but very close to the uniform state (39), and also in a inhomogeneous DMFT approach for $U / t = 8$ (196).

More recently, based on a combined study with DMRG, CP-AFQMC, DMET, and iPEPS, consensus has been reached that the ground state of the doped 2D Hubbard model for $U / t = 8$ $t ^ { \prime } = 0$ ) and $\delta = 1 / 8$ doping is a stripe state with a charge period 8 without coexisting d-wave superconducting order (303), shown in Fig. 3(c). While stripes with periods 5-7 and coexisting d-wave superconductivity are energetically very close to the

LBCO: Lanthanum barium copper oxide, the first discovered high-temperature superconductor and member of the cuprate family.

VMC: variational Monte Carlo

iPEPS: infinite projected entangled-pair states (128)

MC: Monte Carlo (CP-)AFQMC: (constrained-path) auxiliary-field quantum Monte Carlo (300)

DMET: density matrix embedding theory (143)

period 8 stripe, the uniform d-wave state is higher in energy by $\approx 0 . 0 1 t$ , see Fig. 3(d). The estimates of the energy for the period 8 stripe obtained from the four methods are in remarkably close agreement, lying in a range of $- 0 . 7 6 7 { \scriptstyle \pm 0 . 0 0 4 t }$ . The period 8 stripe remains also stable in an extended interaction range ( $U / t \sim 6 - 1 2 )$ , where the energy difference with respect to other stripes becomes larger with decreasing $U / t$ , i.e. the strongest competition is found for $U / t = 1 2$ (whether the stripe period shifts to lower periods at even larger $U / t$ is still an open question). Subsequently, the stripe ground state has been confirmed by VMC (116, 251), in determinant QMC (107), in other DMRG studies (56, 107, 124, 127), and by a variational AFQMC approach (237). The main reason why in previous VMC calculations (106) stripe states were found to be higher in energy than uniform states is that only a period 4 stripe was considered, which is substantially higher in energy than the period 5-8 stripes (303, 251). This resolves the previous discrepancy and also highlights the importance of using the correct unit cell in these calculations.

Moving away from $\delta = 1 / 8$ doping, several approaches predicted that the stripe period decreases with increasing doping (see e.g. Refs. (47, 116, 251, 237)), with a tendency to stabilize insulating, fully-filled stripes of period $\lambda$ at doping $\delta = 1 / \lambda$ (for $U / t = 8$ , $t ^ { \prime } = 0$ ). For dopings in between these fully filled stripes, partially filled stripes with coexisting superconductivity have been found by VMC (251), whereas variational AFQMC predicted phase separation between insulating stripes (237). Based on a combined DMRG and CPAFQMC study, it was concluded that superconductivity in the stripe ground state is absent over an extended doping ( $\delta \sim 0 . 1 - 0 .$ 2) and interaction $U / t \sim 6 - 8 )$ range (232). At low doping phase separation between the antiferromagnetic state at half filling and a partially filled stripe was found to occur around $\delta \approx 0 . 0 8$ for $U / t = 8$ (251, 237) ( $\delta \approx 0 . 0 7$ for $U / t = 1 0$ (47)), but a confirmation of this result with tensor network methods or CPAFQMC is still lacking. (We note that the possibility of phase separation at low doping (59) was already intensely studied many years ago, see Refs. (43, 279) for a review, but this concerned phase separation between the AF state and the uniform d-wave state).

The fate of the uniform d-wave state, i.e. under what conditions it is favored over stripe states, is an important question, but has not been investigated by all methods. The VMC study in Ref. (251) predicted a stable uniform d-wave region in a doping range $0 . 2 0 \lesssim \delta \lesssim 0 . 2 7$ , for $U / t = 8$ ( $t ^ { \prime } = 0$ ), whereas a doping range $0 . 1 9 \lesssim \delta \lesssim 0 . 2 2$ was found with variational AFQMC (237). Based on an approach combining VMC and a tree tensor network for $U / t = 1 0$ ( $t ^ { \prime } = 0$ ) (47), it was concluded that the uniform d-wave state gets stabilized for $0 . 1 7 \lesssim \delta \lesssim 0 . 2 2$ . A similar approach was used in Ref. (187) to study an ab-initio effective one-band model for Hg-based superconductors, where it was found that the long-range Coulomb interaction stabilizes the uniform d-wave state over an even larger doping region, $\delta \gtrsim 0 . 1$ , with a competing period 4 stripe only remaining around $\delta \sim 0 . 1$ . These results suggest that, while the various competing states can already be observed on the level of the simplest Hubbard model, more accurate models with further-neighbor interactions and hoppings are required to quantitatively reproduce the phase diagram of the cuprates. At the same time, to better resolve the tiny differences in energy for these competing states, more accurate methods need to be developed.

5.1.1. Competition at intermediate $U / t$ . While the stripe ground state is now well established at strong coupling $U / t \geq 6$ , the relevance of stripes in the intermediate coupling regime is still not settled. At $U / t = 4$ , using DMRG and CP-AFQMC, the tendency for stripe formation was found to be weaker (232) than at large coupling. A uniform d-wave ground state for $U / t \leq 4$ and large doping $\delta \geq 0 . 3$ was predicted from DiagMC (49, 267), however, smaller dopings were not accessible due to convergence problems of the diagrammatic series. More work will be needed to accurately identify the crossover regime between uniform and stripes states.

![](images/884c3ac741950eabfda5a174290dfd3418709c015e315d4eca1d0e8d4037c0da.jpg)  
Figure 3   
(a-c) Examples of competing states in the doped 2D Hubbard model for $U / t = 8$ and $\delta = 1 / 8$ . The circle radius and the arrow length are proportional to the hole and spin densities, respectively, and the width of the colored bonds scales linearly with the local singlet pairing strength. (a) Uniform d-wave superconducting state with coexisting antiferromagnetic order (from iPEPS). (b) A stripe with charge and spin period 7 with coexisting d-wave superconductivity, and the typical $\pi$ -phase shift in the antiferromagnetic order across the domain wall with maximal hole density (from iPEPS). (c) A period 8 stripe with exactly one hole per unit length per stripe, where superconductivity is entirely suppressed (from CP-AFQMC). Note that due to the $\pi$ -phase shift in the AF order, the period of the spin order is doubled in stripes with an even charge period. (d) Energies of stripes with different charge periods $\lambda$ and the uniform d-wave state (inset) relative to that of the $\lambda = 8$ stripe obtained with different methods. All figures are taken from Ref. (303).

5.1.2. Stripes at finite $t ^ { \prime }$ . Stripe ground states have also been found upon including a negative next-nearest neighbor hopping $t ^ { \prime }$ (corresponding to the hole-doped case) where the preferred stripe period shifts to smaller values with increasing strength of $| t ^ { \prime } | / t$ (116, 107, 198, 124, 127). (A sufficiently large positive $t ^ { \prime } / t \gtrsim 0 . 1 5$ , in contrast, stabilizes the uniform d-wave state over the stripe state (107, 198)). Interestingly, a period 4 stripe, which is the typical period found in experiments (253), is stabilized at $1 / 8$ doping over a wide range of $t ^ { \prime }$ , $0 . 1 6 ( 4 ) < | t ^ { \prime } | / t < 0 . 4 2 3 ( 1 0 )$ (198) (a similar lower bound was found in Ref. (116)), which includes the values that have been predicted as realistic parameters for different cuprate materials (3, 98, 97). Both iPEPS (198) and VMC (116) predict period 4 stripes without coexisting d-wave order at $1 / 8$ doping. However, in contrast to VMC, iPEPS finds coexisting d-wave superconductivity in the period 5-7 stripes at $1 / 8$ doping, and in the period 4 stripe at larger doping $0 . 1 4 \lesssim \delta < 0 . 2 5$ (corresponding to a hole density per stripe unit length, $0 . 5 7 \lesssim \rho _ { l } < 1$ ; a similar range was also found for the period 5 stripe). Coexisting superconductivity in the period 4 stripe was found on a width-4 cylinder using DMRG (124, 127, 249) (also in the $t$ - $J$ model (51, 125)), however, it was pointed out in Ref. (249) that the pairing on the width-4 cylinder does not correspond to the ordinary dwave order one would expect in the 2D limit, but to a ”plaquette” d-wave pairing. (Another difference between the width-4 cylinder DMRG and the iPEPS/VMC results is that in the former the spin order is not long ranged but only short ranged.) Clearly, the issue of coexistence or absence of superconductivity in stripe states and its nature (with or without phase shift between neighboring stripes) remains an important topic for future research.

![](images/34ff80890d5e379abfdb45a6fd583bd6a961ed3612de176ea4ab56280622c536.jpg)  
Figure 4   
(a) Many-body density of states from an eight-site dynamical cluster approximation calculation with $U / t = 7$ , $t ^ { \prime } / t = - 0 . 1 5$ and $T / t { = } 0 . 0 5$ for various hole dopings $_ x$ at the antinode and node, respectively (reproduced with permission from APS (161)). (b) Fluctuation diagnostics of a DCA self-energy in the pseudogap regime, showing that short-range spin fluctuations are the origin of the pseudogap in the 2D Hubbard model (reproduced with permission from APS (88)).

5.1.3. Competition in 3-band models of the cuprates. A competition between different low-energy states can also be found in 3-band Hubbard models with parameters relevant for the cuprates. Uniform d-wave superconducting states have been predicted in VMC (291, 292, 270, 297, 14, 298), DMET (41), and cluster DMFT studies (271), while stripe states have been found in DMRG (282) and determinant QMC (fluctuating stripes at finite temperature) (108) studies. In the CP-AFQMC study in Ref. (32) stripes with spin and charge order were found for large values of the charge-transfer energy ( $\Delta = 4 . 4$ eV), whereas for small values $\Delta = 2 . 5 ~ \mathrm { e V }$ ) the charge order becomes weaker and a subtle competition between different spin orders was found. Stripes coexisting with superconductivity have been predicted in a VMC study (292), however, a confirmation of this result with more recent techniques is still lacking.

# 5.2. Pseudogap

CDMFT: cellular dynamical   
mean-field theory (165)

In cuprate materials, the so-called pseudogap appears for dopings smaller than optimal doping and temperatures below $T ^ { * } \sim 3 0 0 \mathrm { K }$ as a suppression of the density of states near the antinode $( \pi , 0 )$ in the Brillouin zone, but not near the node $( \pi / 2 , \pi / 2 )$ . Originally it was identified as a suppression of the NMR Knight shift (2). However, signatures of the pseudogap are found in a wide variety of other probes (111), in particular angle-resolved photoemission spectroscopy (131, 229). Experimental correlation lengths are estimated to be on the order of a few lattice spacings (133). Therefore, the corresponding parameter regime in the Hubbard model is most often studied with cluster methods such as DCA and CDMFT, as they capture short-range correlation well and provide access to spectral functions.

5.2.1. Results from cluster DMFT. Pioneering results demonstrated that the inclusion of short-ranged correlations is sufficient to describe the suppression of the antinodal density of states in the single-particle spectral function upon lowering $T < T ^ { * }$ (166, 112, 164), see also left and middle panel of Fig. 4. These DCA results were corroborated by $2 \times 2$ CDMFT calculations with various impurity solvers, and their temperature, interaction, doping, and bandstructure $( t , t ^ { \prime } )$ dependence explored (193, 37, 149, 254, 301, 159). For instance, (37) showed that, in addition to the strong renormalization of the Fermi surface at small dopings, there is a fundamental asymmetry of systems with negative next-nearest neighbor hopping $t ^ { \prime } / t < 0$ (resembling hole-doped cuprates) and such with $t ^ { \prime } / t > 0$ (electron doped): whereas the hole like Fermi surface curvature of the former is enhanced when approaching the insulating state for small dopings, the system is driven towards a nested Fermi surface in the latter.

5.2.2. Organizing principles: momentum-sector-selective metal-insulator transition, Widom line and Fermi-surface topology. Systematic DCA studies including variation of cluster sizes and doping (79) revealed a robust rationale for the perspective of the pseudogap regime in the $t - t ^ { \prime }$ Hubbard model (where $t ^ { \prime }$ is introduced to distinguish electron from hole doping) as a doping driven Mott transition (see middle panel of Fig. 4): in the heavily doped regime, non-local correlations are small, yielding a nearly isotropic Fermi liquid (in the sense that the quasiparticle lifetimes and weights at the Fermi surface are nearly constant). Reducing the doping towards half-filling introduces a substantial differentiation in momentum space between quasiparticles at the node and at the antinode, such that the shorter lifetimes occur near the antinodal and the longest ones at the nodal point. The system however remains consistent with Fermi liquid theory at any point on the Fermi surface. Reducing the doping further towards half filling establishes a gap near the antinode, while the node remains metallic. In cluster simulations, this is the momentum-dependent (‘sector-selective’) transition that characterizes the pseudogap in the Hubbard model (86). Reducing doping to half-filling leads to a phase transition to a Mott insulator with a substantially larger and isotropic gap. On the electron-doped side, the sector-selective regime is smaller or, if $t ^ { \prime }$ is large enough, absent, and momentum-differentiation is weaker. It has been argued (see e.g. (193)) that the key ingredient for the pseudogap is the proximity to the Mott transition rather than long-range antiferromagnetic fluctuations, which are believed to be the gapping mechanism on the electron-doped side. A two-site minimal model exhibiting a momentum-selective transition is presented in (63, 64).

A different organizing principle has been suggested in $2 \times 2$ CDMFT clusters (236). There, several thermodynamic and dynamic determination criteria for $T ^ { * }$ are found to collapse onto a line of thermodynamic anomalies that emanates from the critical endpoint of the Mott transition at finite doping. This is the so-called Widom line.

Conflicting interpretations exist on the influence of nesting and the van Hove singularity at strong coupling. While 8-site DCA calculations find no substantial effect of the van Hove singularity on the pseudogap (86), DCA and DQMC simulations in (288, 289) find substantial effects. The discrepancy remains unresolved.

# 5.2.3. Insights into the origin of the pseudogap via fluctuation diagnostic approaches.

While observables such as the single-particle spectral function show signatures of the pseudogap, they do not easily reveal the underlying fluctuations that causes this feature. This analysis can be performed by examining the dominant fluctuations (charge, spin or pairing) and their change upon entering the pseudogap regime. This technique is known as fluctuation diagnostics (88). The approach relies on the Dyson-Schwinger equation of motion which relates the (one-particle) self-energy $\Sigma$ to the (two-particle) scattering vertex $F ^ { \prime }$ . Expressing this relation in different fluctuation channels, their (momentum- or frequency resolved) contributions to the self-energy $\tilde { \Sigma } _ { \mathbf { Q } / \Omega }$ can be determined. The right panel of Fig. 4 shows the self-energy and its fluctuation diagnostics calculated in DCA in a region of the 2D phase diagram where the Hubbard model exhibits a pseudogap. While the momentum contributions $\tilde { \Sigma } _ { \mathbf { Q } }$ in the charge and particle-particle channel are uniformly distributed over the momentum vectors considered, in the spin channel there is a clear peak visible at $\mathbf { Q } = ( \pi , \pi )$ . In frequency, only in the spin channel the zero-frequency contribution $\scriptstyle \sum _ { \Omega = 0 }$ dominates, i.e. only the spin fluctuations are long-lived. From these observations one can conclude that well-defined short-ranged magnetic fluctuations lead to the opening of the pseudogap in the 2D Hubbard model. In (287) a fully momentum resolved fluctuation diagnostics has been performed with DiagMC data. The interplay of spin- and charge fluctuations for wide parameter ranges has been computed in DCA in (53). A systematic review of different types and applications of fluctuation diagnostic techniques can be found in (223).

# 5.3. Superconductivity

The spontaneous emergence of superconducting pairing in a system with strong repulsive interactions has been one of the primary drivers for studying the model, and several earlier reviews (43, 20, 165, 254, 217) present the topic in detail. At weak coupling, a superconducting ground state (with several different superconducting symmetries) exists (178, 208, 49, 267), see Sec. 4.1. However, as mentioned in section 5.1, in a substantial parameter regime around $U / t \sim 8$ and for moderate doping, the phase is preempted by various types of stripes. Nevertheless, superconductivity is very close in energy to those states, and minor changes in the model, such as additional non-local hoppings or interactions, may drive it to a superconducting state. The investigation of this superconducting state and its relationship to the pseudogap, charge-ordered, and metallic states, therefore remains an important topic of active research.

The superconducting phase boundary can be determined in two ways: upon cooling from the high-temperature disordered phase by tracking the divergence of the superconducting susceptibility, or upon heating from the low-T phase by investigating the disappearance of the superconducting order parameter.

With normal state calculations, early QMC results on finite-size clusters found $d _ { x ^ { 2 } - y ^ { 2 } }$ as the most likely pairing symmetry in the Hubbard model for moderate doping (283). Large cluster simulations with extrapolations could be performed in DCA (170) and the critical temperature determined, and (30) explored the parameter regimes most conducive to superconductivity.

Cluster DMFT simulations directly in the ordered superconducting state have been performed by several groups on four-site (see e.g. (158, 167, 93, 36, 236)) and eight-site dynamical mean-field clusters (85, 80). These simulations allow to analyze the nature and properties of the superconducting state (including energetics, spectral functions, gap functions, and other response functions), in addition to determining the phase boundary. While considerable finite size effects remain, generic trends such as the energetics of the model or the evolution of response functions coincide with other methods and observations on cuprate materials.

Of considerable interest has been the pairing mechanism of the model. Several works (180, 216), including studies with DCA (171, 168, 169, 172, 82), found that AF fluctuations play the role of pairing “glue” in the model. In (139) the influence of the dynamical vertex structure on the superconducting transition temperature has been analyzed within the DΓA and particle-particle scattering processes have been identified as a one of the main oppressors of $T _ { c }$ .

# 5.4. Bad metal

The model at high temperature and intermediate doping is metallic, but transport properties are inconsistent with Fermi liquid behavior. The characterization of the temperature dependence of the resistivity, which is believed to be linear in temperature over a wide range of temperature, and of other transport properties in this regime has been a matter of recent attention. Results are available from various methods, including linked cluster expansion (195), dynamical mean field theory (204, 48, 195, 26), and lattice Monte Carlo (109).

Calculating the resistivity is technically difficult. The interpretation of finitetemperature results on the Matsubara axis, such as those obtained by continuous-time QMC dynamical mean field solvers or lattice Monte Carlo methods, is complicated by the fact that analytical continuation is unreliable at high temperature, due to the distance of the Matsubara points from the real axis, and that the spacing of Matsubara point changes linearly in $T$ , thereby introducing a systematic uncertainty into any temperature dependence. Current real frequency formulations, such as those based on DMFT (using NRG (48) or ED (26) as impurity solver), neglect vertex corrections (25). Thus, while the regime at very high temperature is well understood, there is an intermediate temperature regime where currently no reliable calculations exist. Modern DiagMC methods formulated in real frequency (245) promise a resolution of this problem.

# 6. Towards the simulation of experimental probes

# 6.1. Angle-resolved photoemission spectroscopy

Much less is known about single- and two-particle excitations in the intermediate-to-strong coupling regime than about the energetics and the phase diagram of the model.

The spectral function is directly observable in photoemission experiment. Up to matrix elements, it corresponds to the imaginary part of the retarded real-frequency Green’s function, which can be obtained from finite-temperature methods (working on the imaginary frequency/time axis) via analytic continuation (122, 61). However, the continuation kernel is ill conditioned, and uncertainties or stochastic noise on the imaginary axis are amplified exponentially, leading to unreliable spectral functions especially at high temperature, away from zero frequency, and for bosonic quantities. Thus, while features such as the existence of a gap or a quasiparticle peak are typically robust, there is considerable uncertainty in the numerical value of gap sizes or peak heights.

Cluster methods (165) have been used to obtain spectral functions at select points in $k$ -space. Interpolation methods for the Green’s function, self-energy, or for cumulants (241)

can then be employed to obtain continuous $k$ -space Green’s functions and extract quasiparticle weights or Fermi surfaces. Special care must be taken to disentangle interpolation artifacts from data. In three dimensions, results from cluster DMFT (69) and lattice Monte Carlo (256) are available.

Several aspects of the spectral function can be obtained without resorting to analytical continuation. For instance, the imaginary time quantity $\beta G ( \beta / 2 )$ converges to the density of states at the Fermi energy for $T \  \ 0$ (255) and quasiparticle weights, gap sizes, or the location of Metal-to-insulator transitions are accessible from fits of the Matsubara selfenergy (79, 71).

# 6.2. Optical conductivities

Within linear response theory, the response of a model to a weak external field is described by a two-particle correlation function consisting of a product of single-particle Green’s functions and its vertex correction (213).

The response to an externally applied electric field corresponds to a current-current correlation function (11). In the simulation of a layered two-dimensional system, the ‘c-axis’ contribution is proportional to a product of two single-particle Green’s functions and the inter-plane hopping, and no vertex corrections appear (65, 161). Interplane conductivities show a clear signature of the pseudogap opening with temperature and doping, consistent with experiments on the cuprates. In contrast, the evaluation of the in-plane conductivity requires vertex corrections (160, 161), which only disappear in single-site (121) and foursite CDMFT (92) due to symmetry. Results for conductivities are available from cluster DMFT at low $T$ and single-site DMFT and high-temperature series expansion (195) as well as Lanczos (25) at high $T$ . Cluster methods find a large insulating gap in the undoped system, a Drude peak with ‘mid-IR’ feature upon doping, and a clear Drude peak in the metallic regime (161).

# 6.3. Raman spectroscopy

Electronic Raman spectroscopy (151, 50) is a versatile photon-in photon-out technique used to probe correlations in correlated electron systems. Depending on the polarization of the incoming and outgoing light, different areas of the Brillouin zone are probed. On a square two-dimensional lattice, two main light polarizations of interest are $\mathrm { B } _ { 1 g }$ (sensitive to areas around $( \pi , \pi )$ ) and $\mathrm { B } _ { 2 g }$ (highlighting $( \pi / 2 , \pi / 2 )$ ).

Simulated Raman results on the 2D model are available from cluster DMFT, with (162) and without (161, 214) vertex corrections, as well as in the superconducting state (81). They show a two-magnon Raman peak in the insulator, signatures of the pseudogap upon doping, and a temperature- and doping evolution generally consistent with experiment.

# 6.4. Magnetic response

Simulating the full momentum-and energy-dependent magnetic susceptibility or structure factor, such as it would be measured by neutron spectroscopy, is an important open problem. Lattice and quantum cluster methods do not have enough momentum resolution to capture the momentum resolution in an unbiased way, and results therefore come from approximate methods such as dual fermions (153, 156). These results can be directly compared to neutron spectroscopy on the cuprates (38).

Quantum cluster methods are better suited to simulating the local magnetic susceptibility, as it is measured e.g. in nuclear magnetic resonance. Results for the Knight shift, spin-echo decay time, and relaxation rates are presented in (31) and show the characteristic suppression of the NMR Knight shift in the pseudogap regime, along with a differentiation between ‘oxygen’ and ‘copper’ relaxation rates.

# 7. Generalizations and extensions

# 7.1. The 2D Hubbard model on other lattices

We so far discussed the Hubbard model on the square and cubic lattices. The model displays additional interesting properties on lattices that are not square. In particular, the interplay between frustration and correlation may lead to exotic magnetism at half filling, and doping holes may result in additional exotic electronic states.

Honeycomb lattice. The model on the honeycomb lattice is studied mostly due to its connection to graphene. The lattice is bipartite but has a Fermi surface that is very different from that of the square lattice. At half filling, the Fermi surface shrinks to two Dirac points, which causes AF order to appear only when $U$ is larger than a critical value $U _ { c }$ (240). This makes the model an ideal playground to study the interaction-driven metal-insulator transition. At half filling, due to the absence of the sign problem, the model can be efficiently studied with QMC. It is now well established that there is a direct phase transition from a Dirac semi-metal to an AF Mott insulator at a critical $U _ { c } / t \approx 3 . 8$ (239, 9) (and no intermediate spin liquid phase). The phase transition is in the Gross-Neveu-Yukawa universality class (9, 189). Away from half filling, much attention was paid to one quarter doping, where the Fermi-surface has a nesting feature. Nesting in a Fermi surface usually triggers an instability towards an ordered state in the weak interaction region. Chiral $d + i d$ superconducting order was found by several groups with a variety of methods (184, 269, 78).

Triangular lattice. The triangular lattice is the simplest lattice with geometric frustration and may be relevant for certain organic materials (132). At half filling, 120 degree magnetic order was confirmed by different methods (24, 275) in the Heisenberg model. The evolution of the phase diagram with $U$ at half-filling is still under debate (see Refs. (244, 252, 156) and references therein). In the most recent DMRG study on an infinite cylinder (244) a chiral spin liquid phase was found between the metallic phase at weak interaction and the 120 degree magnetically ordered phase at strong interaction. However, the latest VMC study (252) did not find evidence of an intermediate spin liquid phase, except upon adding a sufficiently large $t ^ { \prime }$ . More studies of large systems with high accuracy are needed to resolve this controversy. At finite temperatures a multi-method study of the metal-to-insulator crossover has been recently performed (286), where increased chiral correlations coexisting with stripy antiferromagnetic correlations at intermediate coupling strengths have also been found. Progress in computing frequency-dependent magnetic and charge susceptibilities has been achieved based on the ladder dual fermion approximation (156).

Kagome lattice. The Kagome lattice is another commonly studied lattice with geometrical frustration. Unlike other lattices discussed here, no magnetic order is found at half filling in the strongly interacting limit, and there is a growing consensus that the ground state is a quantum spin liquid (see (157) and references therein). The Mott transition at half-filling was studied in (186) with cluster DMFT, where a critical coupling $U _ { c } / t \sim 8 . 2 2$ was found. In (123), a Wigner crystal state was found in the lightly doped $t$ - $J$ model based on DMRG. The investigation of the physics at larger doping is still underway. In (135), a multi-method study with DQMC, DMFT and DΓA investigated the magnetic correlations across the Mott transition.

# 7.2. The attractive model

The attractive ( $U < 0$ ) Hubbard model is often used as a model system for electronic superconductivity and superconducting phase transitions. On bipartite lattices, the attractive interaction can be transformed to a repulsive one with a partial particle-hole transformation: $\hat { c } _ { i \uparrow }  \hat { d } _ { i \uparrow } , \hat { c } _ { i \downarrow }  ( - 1 ) ^ { i } \hat { d } _ { i \downarrow } ^ { \dagger }$ . With this transformation, the spin-balanced attractive Hubbard model at arbitrary filling is mapped to a spin-imbalanced repulsive Hubbard model at halffilling.

QMC methods do not suffer from a sign problem here, and therefore accurate calculations of very large system sizes at low temperature are possible (219). At half filling, onsite s-wave pairing and charge density wave order at $( \pi , \pi )$ coexist (99), which correspond to the AF N´eel order in the spin-balanced repulsive Hubbard model at half filling. Away from half filling, only the onsite pairing survives and the model displays a KT phase transition at finite temperature. The KT transition temperature goes to zero as the system approaches half filling (219, 181), see (191) for its accurate determination. Moreover, superconductivity can be significantly enhanced if the Fermi energy is close to a logarithmic Van Hove singularity in the density of states (100). The attractive Hubbard model remains sign problem free even with a Rashba spin-orbit coupling (230).

# 7.3. Multi-orbital models

One may envisage an approach that gradually, in a ‘bottom-up’ manner, adds more-andmore orbitals and interactions to the model until the full electronic structure Hamiltonian is recovered. A first step along this route leads to multi-orbital models with local Hubbard interactions. The number of possible models quickly grows and parameter choices become material specific. Cuprate physics has inspired the 3-orbital Emery (58, 41) or p-d model, motivated by a downfolding of electronic structure to three, instead of one, orbitals, and the bilayer Hubbard model (173). For a discussion of competing ground states in the three-orbital model see Sec. 5.1.3. Oxide perovskites have been studied in three-orbital generalizations of the Hubbard model. Typically, inter-orbital ‘Slater-Kanamori’ terms that are not of the density-density type are also included (118). These interactions are characterized by three parameters $U$ , $U ^ { \prime }$ , and $J$ . The model, most often studied with single-site multi-orbital DMFT, has given rise to the so-called ‘Hunds’ metals (72). The joint application of band downfolding techniques and treatment of the resulting low-energy multiorbital model with DMFT (DFT $^ +$ DMFT) is a frequently used strategy for the description of realistic materials (144).

# 7.4. Models with non-local interactions

Instead of adding additional orbitals with local interactions, one may consider adding additional non-local interactions to the single-orbital Hubbard model. The simplest step along this route leads to the extended Hubbard model, where a repulsive nearest-neighbor densitydensity term $V$ is added to the local $U$ . The extended Hubbard model is a paradigmatic model for charge order, as the system is driven to a charge ordered state as $V$ is increased and the temperature is lowered, leading to an interplay of charge order, correlation, antiferromagnetism, metallic, and Mott insulating behavior.

For this reason, the system has been studied within DCA (247, 248, 126, 192), where these interactions are treated explicitly, as well as within the so-called dual boson approach (210, 243), where they are treated in a diagrammatic expansion around DMFT.

# 7.5. Non-equilibrium and driven system

Real-time dependence of Hubbard models outside of linear response is a topic that has recently found much interest. Non-equilibrium can occur in many varieties, including quantum quenches (where parameters of the model are suddenly changed); the coupling to an external driving field (such as an electromagnetic field in a pump-probe setup); or the application of a voltage and the evaluation of currents in the short-time transient or longtime steady-state limit. In the long-time limit, there is a question of thermalization to a steady state or to equilibrium, and there are interesting questions on the destruction and reestablishment of ordered phases and of non-equilibrium ‘phases’ (188).

Reliable and generic numerical tools for these setups are mostly absent, and developing them is a field with great promise. Single-site and small cluster dynamical mean field calculations have been performed for most of these setups (6). Floquet systems (i.e. systems exposed to a periodic drive) have also been studied in cold atomic gas setups (177, 215).

# 8. Conclusions and perspectives

In summary, thanks to substantial advances with different computational methods in recent years, controlled numerical solutions of the Hubbard model in various regions of the phase diagram have become available. This has led to a consensus on several aspects of the model. For example, the longstanding controversy over stripe states has been resolved, and it is now widely accepted that they are the ground state over an extended doping, interaction, and $t ^ { \prime }$ range. Similarly, there is a consensus that the pseudogap at strong coupling is caused by strong short-range antiferromagnetic fluctuations.

Despite all of this progress, there remain many open challenges, such as determining the precise locations of phase boundaries (in particular the parameter region with d-wave superconductivity), investigating the role of phase separation at low doping with more methods, and understanding the interplay of superconductivity and stripe order in partially filled stripes. Another open problem is the accurate study of the competition between stripe and uniform phases at finite temperature, which will be important to connect the current ground state results (mostly from wave function based methods) with the finite temperature results (predominantly from Green’s function based approaches). More accurate techniques beyond single-site DMFT for transport calculations (e.g. fully vertex corrected resistivities) are needed to fully reveal the physics of the high-temperature metallic regime, which so far has remained largely unexplored by numerical approaches. Similarly, more direct and controlled access to real-time evolution and real frequency observables is an essential future direction. The physics of models with more orbitals and/or longer ranged interactions remains largely unexplored with accurate methods, and reliable algorithms are yet to be developed. Such methods will be essential to connect calculations on the single-band model to multi-band Hubbard models and electronic structure Hamiltonians without resorting to crude downfolding techniques.

In view of these rapid advances, the prospects of addressing some of these issues in the near future seem promising. For example, tensor network simulations in 2D have recently been extended to finite temperature (see e.g. (285, 42, 29)), and already been used to study the onset of stripe correlations at $\delta = 1 / 1 6$ doping (285). More finite temperature results in other parameter regimes as well as excitation spectra (17, 258, 199, 257) from tensor network approaches can be expected in future. Progress in computing dynamical quantities has also recently been achieved by dynamical variational Monte Carlo approaches (62, 28), with a first application to the 2D Hubbard model in Ref. (28). Moreover, diagrammatic approaches based on the two-particle vertex are being extended to real frequencies (147).

Finite-temperature methods have similarly made rapid progress. Recent years have seen the advent of large-cluster dynamical mean field studies that could be extrapolated to the thermodynamic limit in practice; extensions of the dynamical mean field theory that became more-and-more accurate, and the emergence of continuous-time and DiagMC methods that are orders of magnitude more powerful than previous techniques.

The development of new, generally applicable numerical techniques which overcome the shortcomings of existing methods therefore remains the most urgent need for addressing the open issues. While this article did not focus on technical aspects of these calculations, most of the advances achieved over the last 15 years can directly be traced back to algorithmic and numerical progress.

# DISCLOSURE STATEMENT

The authors are not aware of any affiliations, memberships, funding, or financial holdings that might be perceived as affecting the objectivity of this review.

# ACKNOWLEDGMENTS

We acknowledge helpful input from F. Becca, P. M. Bonetti, M. Ferrero, A. Georges, C. Hille, S. Kivelson, M. Klett, F. Kugler, J. P. F. LeBlanc, T. Maier, W. Metzner, B. Ponsioen, F. Simkovic, and A. Toschi. EG acknowledges support by NSF DMR 2001465 and the ˇ Simons Collaboration on the Many-Electron Problem. SA acknowledges financial support from the Deutsche Forschungsgemeinschaft (DFG) through Project No. AN 815/6-1. PC acknowledges funding from the European Research Council (ERC) under the European Union’s Horizon 2020 research and innovation programme (grant agreement No 677061).

# LITERATURE CITED

1. Agterberg, D. F., J. S. Davis, S. D. Edkins, E. Fradkin, D. J. Van Harlingen, S. A. Kivelson, P. A. Lee, L. Radzihovsky, J. M. Tranquada, and Y. Wang, 2020, Annu. Rev. Condens. Matter Phys. 11(1), 231, ISSN 1947-5454, publisher: Annual Reviews, URL https://www. annualreviews.org/doi/10.1146/annurev-conmatphys-031119-050711. 2. Alloul, H., T. Ohno, and P. Mendels, 1989, Phys. Rev. Lett. 63, 1700, URL https://link. aps.org/doi/10.1103/PhysRevLett.63.1700. 3. Andersen, O., A. Liechtenstein, O. Jepsen, and F. Paulsen, 1995, Journal of Physics and Chemistry of Solids 56(12), 1573 , ISSN 0022-3697, proceedings of the Conference on Spectro

scopies in Novel Superconductors, URL http://www.sciencedirect.com/science/article/ pii/0022369795002693.   
4. Anderson, P., 1997, Advances in Physics 46(1), 3, URL https://doi.org/10.1080/ 00018739700101478.   
5. Anderson, P. W., 1959, Phys. Rev. 115(1), 2, publisher: American Physical Society, URL https://link.aps.org/doi/10.1103/PhysRev.115.2.   
6. Aoki, H., N. Tsuji, M. Eckstein, M. Kollar, T. Oka, and P. Werner, 2014, Rev. Mod. Phys. 86, 779, URL https://link.aps.org/doi/10.1103/RevModPhys.86.779.   
7. Arovas, D. P., E. Berg, S. Kivelson, and S. Raghu, 2021, arXiv e-prints , arXiv:2103.120972103. 12097.   
8. Arute, F., K. Arya, R. Babbush, D. Bacon, J. C. Bardin, R. Barends, A. Bengtsson, S. Boixo, M. Broughton, B. B. Buckley, D. A. Buell, B. Burkett, et al., 2020, arXiv e-prints , arXiv:2010.079652010.07965.   
9. Assaad, F. F., and I. F. Herbut, 2013, Phys. Rev. X 3, 031010, URL https://link.aps.org/ doi/10.1103/PhysRevX.3.031010.   
10. Assaad, F. F., and M. Imada, 1996, Phys. Rev. Lett. 76, 3176, URL https://link.aps.org/ doi/10.1103/PhysRevLett.76.3176.   
11. Basov, D. N., and T. Timusk, 2005, Rev. Mod. Phys. 77, 721, URL https://link.aps.org/ doi/10.1103/RevModPhys.77.721.   
12. Becca, F., L. Capriotti, and S. Sorella, 2001, Phys. Rev. Lett. 87(16), 167005, URL http: //link.aps.org/doi/10.1103/PhysRevLett.87.167005.   
13. Berg, E., E. Fradkin, E.-A. Kim, S. A. Kivelson, V. Oganesyan, J. M. Tranquada, and S. C. Zhang, 2007, Phys. Rev. Lett. 99(12), 127003, URL http://link.aps.org/doi/10. 1103/PhysRevLett.99.127003.   
14. Biborski, A., M. Zegrodnik, and J. Spa lek, 2020, Phys. Rev. B 101, 214504, URL https: //link.aps.org/doi/10.1103/PhysRevB.101.214504.   
15. Bickers, N. E., D. J. Scalapino, and S. R. White, 1989, Phys. Rev. Lett. 62, 961, URL https://link.aps.org/doi/10.1103/PhysRevLett.62.961.   
16. Blankenbecler, R., D. J. Scalapino, and R. L. Sugar, 1981, Phys. Rev. D 24, 2278, URL https://link.aps.org/doi/10.1103/PhysRevD.24.2278.   
17. Bohrdt, A., E. Demler, F. Pollmann, M. Knap, and F. Grusdt, 2020, Phys. Rev. B 102(3), 035139, publisher: American Physical Society, URL https://link.aps.org/doi/10.1103/ PhysRevB.102.035139.   
18. Borejsza, K., and N. Dupuis, 2004, Phys. Rev. B 69, 085119, URL https://link.aps.org/ doi/10.1103/PhysRevB.69.085119.   
19. Bulla, R., T. A. Costi, and T. Pruschke, 2008, Rev. Mod. Phys. 80, 395, URL https://link. aps.org/doi/10.1103/RevModPhys.80.395.   
20. Bulut, N., 2002, Advances in Physics 51(7), 1587, URL https://doi.org/10.1080/ 00018730210155142.   
21. Bulut, N., D. J. Scalapino, and S. R. White, 1994, Phys. Rev. Lett. 72(5), 705, URL https: //link.aps.org/doi/10.1103/PhysRevLett.72.705.   
22. Byrnes, T., N. Y. Kim, K. Kusudo, and Y. Yamamoto, 2008, Phys. Rev. B 78, 075320, URL https://link.aps.org/doi/10.1103/PhysRevB.78.075320.   
23. Capone, M., and G. Kotliar, 2006, Phys. Rev. B 74(5), 054513, URL https://link.aps.org/ doi/10.1103/PhysRevB.74.054513.   
24. Capriotti, L., A. E. Trumper, and S. Sorella, 1999, Phys. Rev. Lett. 82, 3899, URL https: //link.aps.org/doi/10.1103/PhysRevLett.82.3899.   
25. Vuˇciˇcevi´c, J., J. Kokalj, R. Zitko, N. Wentzell, D. Tanaskovi´c, and J. Mravlje, 2019, Phys. ˇ Rev. Lett. 123, 036601, URL https://link.aps.org/doi/10.1103/PhysRevLett.123.036601.   
26. Cha, P., A. A. Patel, E. Gull, and E.-A. Kim, 2020, Phys. Rev. Research 2, 033434, URL https://link.aps.org/doi/10.1103/PhysRevResearch.2.033434.   
27. Chakravarty, S., B. I. Halperin, and D. R. Nelson, 1988, Phys. Rev. Lett. 60, 1057, URL https://link.aps.org/doi/10.1103/PhysRevLett.60.1057.   
28. Charlebois, M., and M. Imada, 2020, Phys. Rev. X 10(4), 041023, ISSN 2160-3308, URL https://link.aps.org/doi/10.1103/PhysRevX.10.041023.   
29. Chen, B.-B., C. Chen, Z. Chen, J. Cui, Y. Zhai, A. Weichselbaum, J. von Delft, Z. Y. Meng, and W. Li, 2021, Physical Review B 103(4), ISSN 2469-9969, URL http://dx.doi.org/10. 1103/PhysRevB.103.L041107.   
30. Chen, X., J. P. F. LeBlanc, and E. Gull, 2015, Phys. Rev. Lett. 115, 116402, URL https: //link.aps.org/doi/10.1103/PhysRevLett.115.116402.   
31. Chen, X., J. P. F. Leblanc, and E. Gull, 2017, Nature Communications 8, 14986.   
32. Chiciak, A., E. Vitali, and S. Zhang, 2020, Phys. Rev. B 102, 214512, URL https://link. aps.org/doi/10.1103/PhysRevB.102.214512.   
33. Chubukov, A. V., 1993, Phys. Rev. B 48, 1097, URL https://link.aps.org/doi/10.1103/ PhysRevB.48.1097.   
34. Chubukov, A. V., and D. M. Frenkel, 1992, Phys. Rev. B 46, 11884, URL https://link.aps. org/doi/10.1103/PhysRevB.46.11884.   
35. Chubukov, A. V., and K. A. Musaelian, 1995, Phys. Rev. B 51, 12605, URL https://link. aps.org/doi/10.1103/PhysRevB.51.12605.   
36. Civelli, M., 2009, Phys. Rev. B 79, 195113, URL https://link.aps.org/doi/10.1103/ PhysRevB.79.195113.   
37. Civelli, M., M. Capone, S. S. Kancharla, O. Parcollet, and G. Kotliar, 2005, Phys. Rev. Lett. 95, 106402, URL https://link.aps.org/doi/10.1103/PhysRevLett.95.106402.   
38. Coldea, R., S. M. Hayden, G. Aeppli, T. G. Perring, C. D. Frost, T. E. Mason, S.-W. Cheong, and Z. Fisk, 2001, Phys. Rev. Lett. 86, 5377, URL https://link.aps.org/doi/10.1103/ PhysRevLett.86.5377.   
39. Corboz, P., T. M. Rice, and M. Troyer, 2014, Phys. Rev. Lett. 113(4), 046402, URL http: //link.aps.org/doi/10.1103/PhysRevLett.113.046402.   
40. Corboz, P., S. R. White, G. Vidal, and M. Troyer, 2011, Phys. Rev. B 84(4), 041108, URL http://link.aps.org/doi/10.1103/PhysRevB.84.041108.   
41. Cui, Z.-H., C. Sun, U. Ray, B.-X. Zheng, Q. Sun, and G. K.-L. Chan, 2020, Phys. Rev. Research 2, 043259, URL https://link.aps.org/doi/10.1103/PhysRevResearch.2.043259.   
42. Czarnik, P., J. Dziarmaga, and P. Corboz, 2019, Phys. Rev. B 99(3), 035115, URL https: //link.aps.org/doi/10.1103/PhysRevB.99.035115.   
43. Dagotto, E., 1994, Rev. Mod. Phys. 66, 763, URL https://link.aps.org/doi/10.1103/ RevModPhys.66.763.   
44. Dagotto, E., A. Moreo, F. Ortolani, D. Poilblanc, and J. Riera, 1992, Phys. Rev. B 45, 10741, URL https://link.aps.org/doi/10.1103/PhysRevB.45.10741.   
45. Damascelli, A., Z. Hussain, and Z.-X. Shen, 2003, Rev. Mod. Phys. 75, 473, URL https: //link.aps.org/doi/10.1103/RevModPhys.75.473.   
46. Dar´e, A.-M., and G. Albinet, 2000, Phys. Rev. B 61, 4567, URL https://link.aps.org/doi/ 10.1103/PhysRevB.61.4567.   
47. Darmawan, A. S., Y. Nomura, Y. Yamaji, and M. Imada, 2018, Phys. Rev. B 98(20), 205132, URL https://link.aps.org/doi/10.1103/PhysRevB.98.205132.   
48. Deng, X., J. Mravlje, R. Zitko, M. Ferrero, G. Kotliar, and A. Georges, 2013, Phys. Rev. Lett. ˇ 110, 086401, URL https://link.aps.org/doi/10.1103/PhysRevLett.110.086401.   
49. Deng, Y., E. Kozik, N. V. Prokof’ev, and B. V. Svistunov, 2015, EPL 110(5), 57001, ISSN 0295-5075, URL http://iopscience.iop.org/0295-5075/110/5/57001.   
50. Devereaux, T. P., and R. Hackl, 2007, Rev. Mod. Phys. 79, 175, URL https://link.aps. org/doi/10.1103/RevModPhys.79.175.   
51. Dodaro, J. F., H.-C. Jiang, and S. A. Kivelson, 2017, Phys. Rev. B 95(15), 155116, URL https://link.aps.org/doi/10.1103/PhysRevB.95.155116.   
52. Dombre, Thierry, 1990, J. Phys. France 51(9), 847, URL https://doi.org/10.1051/jphys: 01990005109084700.   
53. Dong, X., and E. Gull, 2020, Phys. Rev. B 101, 195115, URL https://link.aps.org/doi/ 10.1103/PhysRevB.101.195115.   
54. Eberlein, A., and W. Metzner, 2014, Phys. Rev. B 89, 035126, URL https://link.aps.org/ doi/10.1103/PhysRevB.89.035126.   
55. Eckhardt, C. J., C. Honerkamp, K. Held, and A. Kauch, 2020, Phys. Rev. B 101, 155104, URL https://link.aps.org/doi/10.1103/PhysRevB.101.155104.   
56. Ehlers, G., S. R. White, and R. M. Noack, 2017, Physical Review B 95(12), ISSN 2469-9950, 2469-9969, arXiv: 1701.03690, URL http://arxiv.org/abs/1701.03690.   
57. Eichenberger, D., and D. Baeriswyl, 2007, Phys. Rev. B 76(18), 180504, URL https://link. aps.org/doi/10.1103/PhysRevB.76.180504.   
58. Emery, V. J., 1987, Phys. Rev. Lett. 58, 2794, URL https://link.aps.org/doi/10.1103/ PhysRevLett.58.2794.   
59. Emery, V. J., S. A. Kivelson, and H. Q. Lin, 1990, Phys. Rev. Lett. 64(4), 475, URL http: //link.aps.org/doi/10.1103/PhysRevLett.64.475.   
60. Esslinger, T., 2010, Annual Review of Condensed Matter Physics 1(1), 129, URL https: //doi.org/10.1146/annurev-conmatphys-070909-104059.   
61. Fei, J., C.-N. Yeh, and E. Gull, 2021, Phys. Rev. Lett. 126, 056402, URL https://link.aps. org/doi/10.1103/PhysRevLett.126.056402.   
62. Ferrari, F., and F. Becca, 2019, Phys. Rev. X 9(3), 031026, URL https://link.aps.org/doi/ 10.1103/PhysRevX.9.031026.   
63. Ferrero, M., P. S. Cornaglia, L. De Leo, O. Parcollet, G. Kotliar, and A. Georges, 2009, Physical Review B 80(6), ISSN 1550-235X, URL http://dx.doi.org/10.1103/PhysRevB.80.064501.   
64. Ferrero, M., P. S. Cornaglia, L. De Leo, O. Parcollet, G. Kotliar, and A. Georges, 2009, EPL (Europhysics Letters) 85(5), 57009, ISSN 1286-4854, URL http://dx.doi.org/10.1209/ 0295-5075/85/57009.   
65. Ferrero, M., O. Parcollet, A. Georges, G. Kotliar, and D. N. Basov, 2010, Phys. Rev. B 82, 054502, URL https://link.aps.org/doi/10.1103/PhysRevB.82.054502.   
66. Fradkin, E., S. A. Kivelson, and J. M. Tranquada, 2015, Rev. Mod. Phys. 87, 457, URL https://link.aps.org/doi/10.1103/RevModPhys.87.457.   
67. Fr´esard, R., M. Dzierzawa, and P. W¨olfle, 1991, Europhysics Letters (EPL) 15(3), 325, URL https://doi.org/10.1209%2F0295-5075%2F15%2F3%2F016.   
68. Fuchs, S., E. Gull, L. Pollet, E. Burovski, E. Kozik, T. Pruschke, and M. Troyer, 2011, Phys. Rev. Lett. 106, 030401, URL https://link.aps.org/doi/10.1103/PhysRevLett.106.030401.   
69. Fuchs, S., E. Gull, M. Troyer, M. Jarrell, and T. Pruschke, 2011, Phys. Rev. B 83, 235113, URL https://link.aps.org/doi/10.1103/PhysRevB.83.235113.   
70. Furukawa, N., and M. Imada, 1992, Journal of the Physical Society of Japan 61(9), 3331, URL https://doi.org/10.1143/JPSJ.61.3331.   
71. Georges, A., G. Kotliar, W. Krauth, and M. J. Rozenberg, 1996, Rev. Mod. Phys. 68, 13, URL https://link.aps.org/doi/10.1103/RevModPhys.68.13.   
72. Georges, A., L. d. Medici, and J. Mravlje, 2013, Annual Review of Condensed Matter Physics 4(1), 137, URL https://doi.org/10.1146/annurev-conmatphys-020911-125045.   
73. Georgescu, I. M., S. Ashhab, and F. Nori, 2014, Rev. Mod. Phys. 86, 153, URL https: //link.aps.org/doi/10.1103/RevModPhys.86.153.   
74. Giamarchi, T., and C. Lhuillier, 1991, Phys. Rev. B 43(16), 12943, URL https://link.aps. org/doi/10.1103/PhysRevB.43.12943.   
75. Greif, D., T. Uehlinger, G. Jotzu, L. Tarruell, and T. Esslinger, 2013, Science 340(6138), 1307, ISSN 0036-8075, 1095-9203, publisher: American Association for the Advancement of Science Section: Report, URL https://science.sciencemag.org/content/340/6138/1307.   
76. Gr¨ober, C., R. Eder, and W. Hanke, 2000, Phys. Rev. B 62(7), 4336, URL https://link. aps.org/doi/10.1103/PhysRevB.62.4336.   
77. Gros, C., 1988, Phys. Rev. B 38(1), 931, publisher: American Physical Society, URL https: //link.aps.org/doi/10.1103/PhysRevB.38.931.   
78. Gu, Z.-C., H.-C. Jiang, D. N. Sheng, H. Yao, L. Balents, and X.-G. Wen, 2013, Phys. Rev. B 88, 155112, URL https://link.aps.org/doi/10.1103/PhysRevB.88.155112.   
79. Gull, E., M. Ferrero, O. Parcollet, A. Georges, and A. J. Millis, 2010, Phys. Rev. B 82, 155101, URL https://link.aps.org/doi/10.1103/PhysRevB.82.155101.   
80. Gull, E., and A. J. Millis, 2012, Phys. Rev. B 86(24), 241106, URL https://link.aps.org/ doi/10.1103/PhysRevB.86.241106.   
81. Gull, E., and A. J. Millis, 2013, Phys. Rev. B 88, 075127, URL https://link.aps.org/doi/ 10.1103/PhysRevB.88.075127.   
82. Gull, E., and A. J. Millis, 2014, Phys. Rev. B 90, 041110, URL https://link.aps.org/doi/ 10.1103/PhysRevB.90.041110.   
83. Gull, E., and A. J. Millis, 2015, Nature Physics 11(10), 808, ISSN 1745-2481, URL https: //doi.org/10.1038/nphys3501.   
84. Gull, E., A. J. Millis, A. I. Lichtenstein, A. N. Rubtsov, M. Troyer, and P. Werner, 2011, Rev. Mod. Phys. 83, 349, URL https://link.aps.org/doi/10.1103/RevModPhys.83.349.   
85. Gull, E., O. Parcollet, and A. J. Millis, 2013, Phys. Rev. Lett. 110, 216405, URL https: //link.aps.org/doi/10.1103/PhysRevLett.110.216405.   
86. Gull, E., O. Parcollet, P. Werner, and A. J. Millis, 2009, Phys. Rev. B 80, 245102, URL https://link.aps.org/doi/10.1103/PhysRevB.80.245102.   
87. Gull, E., P. Werner, X. Wang, M. Troyer, and A. J. Millis, 2008, EPL (Europhysics Letters) 84(3), 37009, URL https://doi.org/10.1209%2F0295-5075%2F84%2F37009.   
88. Gunnarsson, O., T. Sch¨afer, J. P. F. LeBlanc, E. Gull, J. Merino, G. Sangiovanni, G. Rohringer, and A. Toschi, 2015, Phys. Rev. Lett. 114, 236402, URL https://link.aps.org/doi/10.1103/ PhysRevLett.114.236402.   
89. Gutzwiller, M. C., 1963, Phys. Rev. Lett. 10, 159, URL https://link.aps.org/doi/10.1103/ PhysRevLett.10.159.   
90. Halboth, C. J., and W. Metzner, 2000, Phys. Rev. Lett. 85(24), 5162, URL https://link. aps.org/doi/10.1103/PhysRevLett.85.5162.   
91. Hart, R. A., P. M. Duarte, T.-L. Yang, X. Liu, T. Paiva, E. Khatami, R. T. Scalettar, N. Trivedi, D. A. Huse, and R. G. Hulet, 2015, Nature 519(7542), 211, ISSN 1476-4687, URL https://doi.org/10.1038/nature14223.   
92. Haule, K., and G. Kotliar, 2007, Europhysics Letters (EPL) 77(2), 27007, URL https://doi. org/10.1209%2F0295-5075%2F77%2F27007.   
93. Haule, K., and G. Kotliar, 2007, Phys. Rev. B 76, 104509, URL https://link.aps.org/doi/ 10.1103/PhysRevB.76.104509.   
94. Hensgens, T., T. Fujita, L. Janssen, X. Li, C. J. Van Diepen, C. Reichl, W. Wegscheider, S. Das Sarma, and L. M. K. Vandersypen, 2017, Nature 548(7665), 70, ISSN 1476-4687, URL https://doi.org/10.1038/nature23022.   
95. Hille, C., D. Rohe, C. Honerkamp, and S. Andergassen, 2020, Phys. Rev. Research 2, 033068, URL https://link.aps.org/doi/10.1103/PhysRevResearch.2.033068.   
96. Himeda, A., T. Kato, and M. Ogata, 2002, Phys. Rev. Lett. 88, 117001, URL http://link. aps.org/doi/10.1103/PhysRevLett.88.117001.   
97. Hirayama, M., T. Misawa, T. Ohgoe, Y. Yamaji, and M. Imada, 2019, Phys. Rev. B 99(24), 245155, URL https://link.aps.org/doi/10.1103/PhysRevB.99.245155.   
98. Hirayama, M., Y. Yamaji, T. Misawa, and M. Imada, 2018, Phys. Rev. B 98(13), ISSN 2469- 9950, 2469-9969, URL https://link.aps.org/doi/10.1103/PhysRevB.98.134501.   
99. Hirsch, J. E., 1985, Phys. Rev. B 31, 4403, URL https://link.aps.org/doi/10.1103/ PhysRevB.31.4403.   
100. Hirsch, J. E., and D. J. Scalapino, 1986, Phys. Rev. Lett. 56, 2732, URL https://link.aps. org/doi/10.1103/PhysRevLett.56.2732.   
101. Hirsch, J. E., and S. Tang, 1989, Phys. Rev. Lett. 62, 591, URL https://link.aps.org/doi/ 10.1103/PhysRevLett.62.591.   
102. Hirschmeier, D., H. Hafermann, E. Gull, A. I. Lichtenstein, and A. E. Antipov, 2015, Phys. Rev. B 92, 144409, URL https://link.aps.org/doi/10.1103/PhysRevB.92.144409.   
103. Hlubina, R., S. Sorella, and F. Guinea, 1997, Phys. Rev. Lett. 78, 1343, URL https://link. aps.org/doi/10.1103/PhysRevLett.78.1343.   
104. Honerkamp, C., and M. Salmhofer, 2001, Phys. Rev. Lett. 87, 187004, URL https://link. aps.org/doi/10.1103/PhysRevLett.87.187004.   
105. Honerkamp, C., M. Salmhofer, N. Furukawa, and T. M. Rice, 2001, Phys. Rev. B 63, 035109, URL https://link.aps.org/doi/10.1103/PhysRevB.63.035109.   
106. Hu, W.-J., F. Becca, and S. Sorella, 2012, Phys. Rev. B 85(8), 081110, URL http://link. aps.org/doi/10.1103/PhysRevB.85.081110.   
107. Huang, E. W., C. B. Mendl, H.-C. Jiang, B. Moritz, and T. P. Devereaux, 2018, npj Quantum Materials 3(1), 22, ISSN 2397-4648, URL https://www.nature.com/articles/ s41535-018-0097-0.   
108. Huang, E. W., C. B. Mendl, S. Liu, S. Johnston, H.-C. Jiang, B. Moritz, and T. P. Devereaux, 2017, Science 358(6367), 1161, ISSN 0036-8075, 1095-9203, URL https://science. sciencemag.org/content/358/6367/1161.   
109. Huang, E. W., R. Sheppard, B. Moritz, and T. P. Devereaux, 2019, Science 366(6468), 987, ISSN 0036-8075, URL https://science.sciencemag.org/content/366/6468/987.   
110. Hubbard, J., 1963, Proc. R. Soc. London, Ser. A 276(1365), 238, URL http://rspa. royalsocietypublishing.org/content/276/1365/238.abstract.   
111. H¨ufner, S., M. A. Hossain, A. Damascelli, and G. A. Sawatzky, 2008, Reports on Progress in Physics 71(6), 062501.   
112. Huscroft, C., M. Jarrell, T. Maier, S. Moukouri, and A. N. Tahvildarzadeh, 2001, Phys. Rev. Lett. 86, 139, URL https://link.aps.org/doi/10.1103/PhysRevLett.86.139.   
113. Husemann, C., and M. Salmhofer, 2009, Phys. Rev. B 79, 195125, URL https://link.aps. org/doi/10.1103/PhysRevB.79.195125.   
114. Hybertsen, M. S., M. Schl¨uter, and N. E. Christensen, 1989, Phys. Rev. B 39, 9028, URL https://link.aps.org/doi/10.1103/PhysRevB.39.9028.   
115. Ibarra-Garc´ıa-Padilla, E., R. Mukherjee, R. G. Hulet, K. R. A. Hazzard, T. Paiva, and R. T. Scalettar, 2020, Phys. Rev. A 102, 033340, URL https://link.aps.org/doi/10.1103/ PhysRevA.102.033340.   
116. Ido, K., T. Ohgoe, and M. Imada, 2018, Phys. Rev. B 97(4), 045138, URL https://link. aps.org/doi/10.1103/PhysRevB.97.045138.   
117. Igoshev, P. A., M. A. Timirgazin, A. A. Katanin, A. K. Arzhnikov, and V. Y. Irkhin, 2010, Phys. Rev. B 81, 094407, URL https://link.aps.org/doi/10.1103/PhysRevB.81.094407.   
118. Imada, M., A. Fujimori, and Y. Tokura, 1998, Rev. Mod. Phys. 70, 1039, URL https://link. aps.org/doi/10.1103/RevModPhys.70.1039.   
119. Irkhin, V. Y., A. A. Katanin, and M. I. Katsnelson, 2001, Phys. Rev. B 64, 165107, URL https://link.aps.org/doi/10.1103/PhysRevB.64.165107.   
120. Jaksch, D., and P. Zoller, 2005, Annals of Physics 315(1), 52 , ISSN 0003-4916, special Issue, URL http://www.sciencedirect.com/science/article/pii/S0003491604001782.   
121. Jarrell, M., J. K. Freericks, and T. Pruschke, 1995, Phys. Rev. B 51, 11704, URL https: //link.aps.org/doi/10.1103/PhysRevB.51.11704.   
122. Jarrell, M., and J. Gubernatis, 1996, Physics Reports 269(3), 133 , ISSN 0370-1573, URL http://www.sciencedirect.com/science/article/pii/0370157395000747.   
123. Jiang, H.-C., T. Devereaux, and S. A. Kivelson, 2017, Phys. Rev. Lett. 119, 067002, URL https://link.aps.org/doi/10.1103/PhysRevLett.119.067002.   
124. Jiang, H.-C., and T. P. Devereaux, 2019, Science 365(6460), 1424, ISSN 0036-8075, 1095-9203, URL https://science.sciencemag.org/content/365/6460/1424.   
125. Jiang, H.-C., Z.-Y. Weng, and S. A. Kivelson, 2018, Phys. Rev. B 98(14), 140505, publisher: American Physical Society, URL https://link.aps.org/doi/10.1103/PhysRevB.98.140505.   
126. Jiang, M., U. R. H¨ahner, T. C. Schulthess, and T. A. Maier, 2018, Phys. Rev. B 97, 184507, URL https://link.aps.org/doi/10.1103/PhysRevB.97.184507.   
127. Jiang, Y.-F., J. Zaanen, T. P. Devereaux, and H.-C. Jiang, 2020, Phys. Rev. Research 2(3), 033073, publisher: American Physical Society, URL https://link.aps.org/doi/10.1103/ PhysRevResearch.2.033073.   
128. Jordan, J., R. Or´us, G. Vidal, F. Verstraete, and J. I. Cirac, 2008, Phys. Rev. Lett. 101(25), 250602.   
129. J¨ordens, R., L. Tarruell, D. Greif, T. Uehlinger, N. Strohmaier, H. Moritz, T. Esslinger, L. De Leo, C. Kollath, A. Georges, V. Scarola, L. Pollet, et al., 2010, Phys. Rev. Lett. 104, 180401, URL https://link.aps.org/doi/10.1103/PhysRevLett.104.180401.   
130. Kanamori, J., 1963, Progress of Theoretical Physics 30(3), 275, ISSN 0033-068X, URL https: //doi.org/10.1143/PTP.30.275.   
131. Kanigel, A., M. R. Norman, M. Randeria, U. Chatterjee, S. Souma, A. Kaminski, H. M. Fretwell, S. Rosenkranz, M. Shi, T. Sato, T. Takahashi, Z. Z. Li, et al., 2006, Nature Physics 2(7), 447.   
132. Kanoda, K., and R. Kato, 2011, Annual Review of Condensed Matter Physics 2(1), 167, URL https://doi.org/10.1146/annurev-conmatphys-062910-140521.   
133. Kastner, M. A., R. J. Birgeneau, G. Shirane, and Y. Endoh, 1998, Rev. Mod. Phys. 70, 897, URL https://link.aps.org/doi/10.1103/RevModPhys.70.897.   
134. Katanin, A. A., and A. P. Kampf, 2003, Phys. Rev. B 68, 195101, URL https://link.aps. org/doi/10.1103/PhysRevB.68.195101.   
135. Kaufmann, J., K. Steiner, R. T. Scalettar, K. Held, and O. Janson, 2020, arXiv e-prints , arXiv:2011.010852011.01085.   
136. Kent, P. R. C., M. Jarrell, T. A. Maier, and T. Pruschke, 2005, Phys. Rev. B 72, 060411, URL https://link.aps.org/doi/10.1103/PhysRevB.72.060411.   
137. Kim, A. J., F. Simkovic, and E. Kozik, 2020, Phys. Rev. Lett. 124, 117602, URL https: //link.aps.org/doi/10.1103/PhysRevLett.124.117602.   
138. Kim, C., P. J. White, Z.-X. Shen, T. Tohyama, Y. Shibata, S. Maekawa, B. O. Wells, Y. J. Kim, R. J. Birgeneau, and M. A. Kastner, 1998, Phys. Rev. Lett. 80, 4245, URL https: //link.aps.org/doi/10.1103/PhysRevLett.80.4245.   
139. Kitatani, M., T. Sch¨afer, H. Aoki, and K. Held, 2019, Phys. Rev. B 99, 041115, URL https: //link.aps.org/doi/10.1103/PhysRevB.99.041115.   
140. Kitatani, M., L. Si, O. Janson, R. Arita, Z. Zhong, and K. Held, 2020, npj Quantum Materials 5(1), ISSN 2397-4648, URL http://dx.doi.org/10.1038/s41535-020-00260-y.   
141. Klett, M., N. Wentzell, T. Sch¨afer, F. Simkovic, O. Parcollet, S. Andergassen, and P. Hansmann, 2020, Phys. Rev. Research 2, 033476, URL https://link.aps.org/doi/10.1103/ PhysRevResearch.2.033476.   
142. Kloss, T., X. Montiel, V. S. d. Carvalho, H. Freire, and C. P´epin, 2016, Rep. Prog. Phys. 79(8), 084507, ISSN 0034-4885, URL https://doi.org/10.1088%2F0034-4885%2F79%2F8%2F084507.   
143. Knizia, G., and G. K.-L. Chan, 2012, Phys. Rev. Lett. 109(18), 186404, URL http://link. aps.org/doi/10.1103/PhysRevLett.109.186404.   
144. Kotliar, G., S. Y. Savrasov, K. Haule, V. S. Oudovenko, O. Parcollet, and C. A. Marianetti, 2006, Rev. Mod. Phys. 78, 865, URL https://link.aps.org/doi/10.1103/RevModPhys.78. 865.   
145. Kotov, V. N., and O. P. Sushkov, 2004, Phys. Rev. B 70, 195105, URL https://link.aps. org/doi/10.1103/PhysRevB.70.195105.   
146. Kozik, E., E. Burovski, V. W. Scarola, and M. Troyer, 2013, Phys. Rev. B 87, 205102, URL https://link.aps.org/doi/10.1103/PhysRevB.87.205102.   
147. Kugler, F. B., S.-S. B. Lee, and J. von Delft, 2021, Multipoint correlation functions: spectral representation and numerical evaluation, 2101.00707.   
148. Kyung, B., V. Hankevych, A.-M. Dar´e, and A.-M. S. Tremblay, 2004, Phys. Rev. Lett. 93, 147004, URL https://link.aps.org/doi/10.1103/PhysRevLett.93.147004.   
149. Kyung, B., S. S. Kancharla, D. S´en´echal, A.-M. S. Tremblay, M. Civelli, and G. Kotliar, 2006, Phys. Rev. B 73, 165114, URL https://link.aps.org/doi/10.1103/PhysRevB.73.165114.   
150. Kyung, B., J.-S. Landry, and A.-M. S. Tremblay, 2003, Phys. Rev. B 68, 174502, URL https: //link.aps.org/doi/10.1103/PhysRevB.68.174502.   
151. Le Tacon, M., A. Sacuto, A. Georges, G. Kotliar, Y. Gallais, D. Colson, and A. Forget, 2006, Nature Physics 2(8), 537, URL https://doi.org/10.1038/nphys362.   
152. LeBlanc, J. P. F., A. E. Antipov, F. Becca, I. W. Bulik, G. K.-L. Chan, C.-M. Chung, Y. Deng, M. Ferrero, T. M. Henderson, C. A. Jim´enez-Hoyos, E. Kozik, X.-W. Liu, et al. (Simons Collaboration on the Many-Electron Problem), 2015, Phys. Rev. X 5, 041041, URL https: //link.aps.org/doi/10.1103/PhysRevX.5.041041.   
153. LeBlanc, J. P. F., S. Li, X. Chen, R. Levy, A. E. Antipov, A. J. Millis, and E. Gull, 2019, Phys. Rev. B 100, 075123, URL https://link.aps.org/doi/10.1103/PhysRevB.100.075123.   
154. Lenihan, C., A. J. Kim, F. Simkovic IV., and E. Kozik, 2021, Phys. Rev. Lett. ˇ 126, 105701, URL https://link.aps.org/doi/10.1103/PhysRevLett.126.105701.   
155. Li, Q., M. H¨ucker, G. D. Gu, A. M. Tsvelik, and J. M. Tranquada, 2007, Phys. Rev. Lett. 99(6), 067001, URL http://link.aps.org/doi/10.1103/PhysRevLett.99.067001.   
156. Li, S., and E. Gull, 2020, Phys. Rev. Research 2, 013295, URL https://link.aps.org/doi/ 10.1103/PhysRevResearch.2.013295.   
157. Liao, H. J., Z. Y. Xie, J. Chen, Z. Y. Liu, H. D. Xie, R. Z. Huang, B. Normand, and T. Xiang, 2017, Phys. Rev. Lett. 118, 137202, URL https://link.aps.org/doi/10.1103/PhysRevLett. 118.137202.   
158. Lichtenstein, A. I., and M. I. Katsnelson, 2000, Phys. Rev. B 62, R9283, URL https://link. aps.org/doi/10.1103/PhysRevB.62.R9283.   
159. Liebsch, A., and N.-H. Tong, 2009, Phys. Rev. B 80, 165126, URL https://link.aps.org/ doi/10.1103/PhysRevB.80.165126.   
160. Lin, N., E. Gull, and A. J. Millis, 2009, Phys. Rev. B 80, 161105, URL https://link.aps. org/doi/10.1103/PhysRevB.80.161105.   
161. Lin, N., E. Gull, and A. J. Millis, 2010, Phys. Rev. B 82, 045104, URL https://link.aps. org/doi/10.1103/PhysRevB.82.045104.   
162. Lin, N., E. Gull, and A. J. Millis, 2012, Phys. Rev. Lett. 109, 106401, URL https://link. aps.org/doi/10.1103/PhysRevLett.109.106401.   
163. van Loon, E. G. C. P., H. Hafermann, and M. I. Katsnelson, 2018, Phys. Rev. B 97, 085125, URL https://link.aps.org/doi/10.1103/PhysRevB.97.085125.   
164. Macridin, A., M. Jarrell, T. Maier, P. R. C. Kent, and E. D’Azevedo, 2006, Phys. Rev. Lett. 97, 036401, URL https://link.aps.org/doi/10.1103/PhysRevLett.97.036401.   
165. Maier, T., M. Jarrell, T. Pruschke, and M. H. Hettler, 2005, Rev. Mod. Phys. 77, 1027, URL https://link.aps.org/doi/10.1103/RevModPhys.77.1027.   
166. Maier, T., M. Jarrell, T. Pruschke, and J. Keller, 2000, The European Physical Journal B - Condensed Matter and Complex Systems 13(4), 613, ISSN 1434-6036, URL https://doi. org/10.1007/s100510050077.   
167. Maier, T. A., M. Jarrell, A. Macridin, and C. Slezak, 2004, Phys. Rev. Lett. 92, 027005, URL https://link.aps.org/doi/10.1103/PhysRevLett.92.027005.   
168. Maier, T. A., M. Jarrell, and D. J. Scalapino, 2006, Phys. Rev. B 74, 094513, URL https: //link.aps.org/doi/10.1103/PhysRevB.74.094513.   
169. Maier, T. A., M. Jarrell, and D. J. Scalapino, 2007, Phys. Rev. B 75, 134519, URL https: //link.aps.org/doi/10.1103/PhysRevB.75.134519.   
170. Maier, T. A., M. Jarrell, T. C. Schulthess, P. R. C. Kent, and J. B. White, 2005, Phys. Rev. Lett. 95(23), 237001, URL https://link.aps.org/doi/10.1103/PhysRevLett.95.237001.   
171. Maier, T. A., M. S. Jarrell, and D. J. Scalapino, 2006, Phys. Rev. Lett. 96, 047005, URL https://link.aps.org/doi/10.1103/PhysRevLett.96.047005.   
172. Maier, T. A., A. Macridin, M. Jarrell, and D. J. Scalapino, 2007, Phys. Rev. B 76, 144516, URL https://link.aps.org/doi/10.1103/PhysRevB.76.144516.   
173. Maier, T. A., and D. J. Scalapino, 2011, Phys. Rev. B 84, 180513, URL https://link.aps. org/doi/10.1103/PhysRevB.84.180513.   
174. Markiewicz, R. S., S. Sahrakorpi, M. Lindroos, H. Lin, and A. Bansil, 2005, Phys. Rev. B 72, 054519, URL https://link.aps.org/doi/10.1103/PhysRevB.72.054519.   
175. Mazurenko, A., C. S. Chiu, G. Ji, M. F. Parsons, M. Kan´asz-Nagy, R. Schmidt, F. Grusdt, E. Demler, D. Greif, and M. Greiner, 2017, Nature 545(7655), 462, ISSN 1476-4687, URL https://doi.org/10.1038/nature22362.   
176. Mermin, N. D., and H. Wagner, 1966, Phys. Rev. Lett. 17, 1307, URL http://link.aps.org/ doi/10.1103/PhysRevLett.17.1307.   
177. Messer, M., K. Sandholzer, F. G¨org, J. Minguzzi, R. Desbuquois, and T. Esslinger, 2018, Phys. Rev. Lett. 121, 233603, URL https://link.aps.org/doi/10.1103/PhysRevLett.121.233603.   
178. Metzner, W., M. Salmhofer, C. Honerkamp, V. Meden, and K. Sch¨onhammer, 2012, Rev. Mod. Phys. 84, 299, URL https://link.aps.org/doi/10.1103/RevModPhys.84.299.   
179. Misawa, T., and M. Imada, 2014, Phys. Rev. B 90(11), 115137, URL http://link.aps.org/ doi/10.1103/PhysRevB.90.115137.   
180. Monthoux, P., A. V. Balatsky, and D. Pines, 1991, Phys. Rev. Lett. 67, 3448, URL https: //link.aps.org/doi/10.1103/PhysRevLett.67.3448.   
181. Moreo, A., and D. J. Scalapino, 1991, Phys. Rev. Lett. 66, 946, URL https://link.aps.org/ doi/10.1103/PhysRevLett.66.946.   
182. Mott, N. F., 1949, Proceedings of the Physical Society. Section A 62(7), 416, URL https: //doi.org/10.1088%2F0370-1298%2F62%2F7%2F303.   
183. Moukouri, S., and M. Jarrell, 2001, Phys. Rev. Lett. 87, 167010, URL https://link.aps. org/doi/10.1103/PhysRevLett.87.167010.   
184. Nandkishore, R., L. S. Levitov, and A. V. Chubukov, 2012, Nature Physics 8(2), 158, ISSN 1745-2481, URL http://dx.doi.org/10.1038/nphys2208.   
185. Neumayr, A., and W. Metzner, 2003, Phys. Rev. B 67, 035112, URL https://link.aps.org/ doi/10.1103/PhysRevB.67.035112.   
186. Ohashi, T., N. Kawakami, and H. Tsunetsugu, 2006, Phys. Rev. Lett. 97, 066401, URL https://link.aps.org/doi/10.1103/PhysRevLett.97.066401.   
187. Ohgoe, T., M. Hirayama, T. Misawa, K. Ido, Y. Yamaji, and M. Imada, 2020, Phys. Rev. B 101(4), 045124, publisher: American Physical Society, URL https://link.aps.org/doi/10. 1103/PhysRevB.101.045124.   
188. Oka, T., and S. Kitamura, 2019, Annual Review of Condensed Matter Physics 10(1), 387, URL https://doi.org/10.1146/annurev-conmatphys-031218-013423.   
189. Otsuka, Y., S. Yunoki, and S. Sorella, 2016, Phys. Rev. X 6, 011029, URL https://link.aps. org/doi/10.1103/PhysRevX.6.011029.   
190. Paiva, T., Y. L. Loh, M. Randeria, R. T. Scalettar, and N. Trivedi, 2011, Phys. Rev. Lett. 107, 086401, URL https://link.aps.org/doi/10.1103/PhysRevLett.107.086401.   
191. Paiva, T., R. R. dos Santos, R. T. Scalettar, and P. J. H. Denteneer, 2004, Phys. Rev. B 69, 184501, URL https://link.aps.org/doi/10.1103/PhysRevB.69.184501.   
192. Paki, J., H. Terletska, S. Iskakov, and E. Gull, 2019, Phys. Rev. B 99, 245146, URL https: //link.aps.org/doi/10.1103/PhysRevB.99.245146.   
193. Parcollet, O., G. Biroli, and G. Kotliar, 2004, Phys. Rev. Lett. 92, 226402, URL https: //link.aps.org/doi/10.1103/PhysRevLett.92.226402.   
194. Pavarini, E., I. Dasgupta, T. Saha-Dasgupta, O. Jepsen, and O. K. Andersen, 2001, Phys. Rev. Lett. 87, 047003, URL https://link.aps.org/doi/10.1103/PhysRevLett.87.047003.   
195. Perepelitsky, E., A. Galatas, J. Mravlje, R. Zitko, E. Khatami, B. S. Shastry, and A. Georges, ˇ 2016, Phys. Rev. B 94, 235115, URL https://link.aps.org/doi/10.1103/PhysRevB.94. 235115.   
196. Peters, R., and N. Kawakami, 2014, Phys. Rev. B 89(15), 155134, publisher: American Physical Society, URL https://link.aps.org/doi/10.1103/PhysRevB.89.155134.   
197. Poilblanc, D., and T. M. Rice, 1989, Phys. Rev. B 39, 9749, URL http://link.aps.org/doi/ 10.1103/PhysRevB.39.9749.   
198. Ponsioen, B., S. S. Chung, and P. Corboz, 2019, Phys. Rev. B 100(19), 195141, URL https: //link.aps.org/doi/10.1103/PhysRevB.100.195141.   
199. Ponsioen, B., and P. Corboz, 2020, Phys. Rev. B 101(19), 195109, URL https://link.aps. org/doi/10.1103/PhysRevB.101.195109.   
200. Powell, B. J., and R. H. McKenzie, 2006, Journal of Physics: Condensed Matter 18(45), R827, URL https://doi.org/10.1088/0953-8984/18/45/r03.   
201. Preuss, R., W. Hanke, C. Gr¨ober, and H. G. Evertz, 1997, Phys. Rev. Lett. 79(6), 1122, URL https://link.aps.org/doi/10.1103/PhysRevLett.79.1122.   
202. Preuss, R., W. Hanke, and W. von der Linden, 1995, Phys. Rev. Lett. 75(7), 1344, URL https://link.aps.org/doi/10.1103/PhysRevLett.75.1344.   
203. Prokof’ev, N. V., and B. V. Svistunov, 1998, Phys. Rev. Lett. 81, 2514, URL https://link. aps.org/doi/10.1103/PhysRevLett.81.2514.   
204. Pruschke, T., M. Jarrell, and J. Freericks, 1995, Advances in Physics 44(2), 187, URL https: //doi.org/10.1080/00018739500101526.   
205. Qin, M., H. Shi, and S. Zhang, 2016, Phys. Rev. B 94, 085103, URL https://link.aps.org/ doi/10.1103/PhysRevB.94.085103.   
206. Qin, M., H. Shi, and S. Zhang, 2017, Phys. Rev. B 96, 075156, URL https://link.aps.org/ doi/10.1103/PhysRevB.96.075156.   
207. Raczkowski, M., M. Capello, D. Poilblanc, R. Fr´esard, and A. M. Oles, 2007, Phys. Rev. B 76(14), 140505, URL http://link.aps.org/doi/10.1103/PhysRevB.76.140505.   
208. Raghu, S., S. A. Kivelson, and D. J. Scalapino, 2010, Phys. Rev. B 81, 224505, URL https: //link.aps.org/doi/10.1103/PhysRevB.81.224505.   
209. Reiss, J., D. Rohe, and W. Metzner, 2007, Phys. Rev. B 75, 075110, URL https://link.aps. org/doi/10.1103/PhysRevB.75.075110.   
210. Rohringer, G., H. Hafermann, A. Toschi, A. A. Katanin, A. E. Antipov, M. I. Katsnelson, A. I. Lichtenstein, A. N. Rubtsov, and K. Held, 2018, Rev. Mod. Phys. 90, 025003, URL https://link.aps.org/doi/10.1103/RevModPhys.90.025003.   
211. Rohringer, G., and A. Toschi, 2016, Phys. Rev. B 94, 125144, URL https://link.aps.org/ doi/10.1103/PhysRevB.94.125144.   
212. Rohringer, G., A. Toschi, A. Katanin, and K. Held, 2011, Phys. Rev. Lett. 107, 256402, URL https://link.aps.org/doi/10.1103/PhysRevLett.107.256402.   
213. Rohringer, G., A. Valli, and A. Toschi, 2012, Phys. Rev. B 86, 125114, URL https://link. aps.org/doi/10.1103/PhysRevB.86.125114.   
214. Sakai, S., S. Blanc, M. Civelli, Y. Gallais, M. Cazayous, M.-A. M´easson, J. S. Wen, Z. J. Xu, G. D. Gu, G. Sangiovanni, Y. Motome, K. Held, et al., 2013, Phys. Rev. Lett. 111, 107001, URL https://link.aps.org/doi/10.1103/PhysRevLett.111.107001.   
215. Sandholzer, K., Y. Murakami, F. G¨org, J. Minguzzi, M. Messer, R. Desbuquois, M. Eckstein, P. Werner, and T. Esslinger, 2019, Phys. Rev. Lett. 123, 193602, URL https://link.aps. org/doi/10.1103/PhysRevLett.123.193602.   
216. Scalapino, D., 1995, Physics Reports 250(6), 329 , ISSN 0370-1573, URL http://www. sciencedirect.com/science/article/pii/037015739400086I.   
217. Scalapino, D. J., 2007, Numerical Studies of the 2D Hubbard Model (Springer New York, New York, NY), chapter 13, ISBN 978-0-387-68734-6, pp. 495–526, URL https://doi.org/ 10.1007/978-0-387-68734-6_13.   
218. Scalapino, D. J., 2012, Rev. Mod. Phys. 84, 1383, URL https://link.aps.org/doi/10.1103/ RevModPhys.84.1383.   
219. Scalettar, R. T., E. Y. Loh, J. E. Gubernatis, A. Moreo, S. R. White, D. J. Scalapino, R. L. Sugar, and E. Dagotto, 1989, Phys. Rev. Lett. 62, 1407, URL https://link.aps.org/doi/ 10.1103/PhysRevLett.62.1407.   
220. Scalettar, R. T., D. J. Scalapino, R. L. Sugar, and D. Toussaint, 1989, Phys. Rev. B 39, 4711, URL https://link.aps.org/doi/10.1103/PhysRevB.39.4711.   
221. Sch¨afer, T., F. Geles, D. Rost, G. Rohringer, E. Arrigoni, K. Held, N. Bl¨umer, M. Aichhorn, and A. Toschi, 2015, Phys. Rev. B 91, 125109, URL https://link.aps.org/doi/10.1103/ PhysRevB.91.125109.   
222. Sch¨afer, T., A. A. Katanin, K. Held, and A. Toschi, 2017, Phys. Rev. Lett. 119, 046402, URL https://link.aps.org/doi/10.1103/PhysRevLett.119.046402.   
223. Sch¨afer, T., and A. Toschi, 2021, Journal of Physics: Condensed Matter URL http: //iopscience.iop.org/article/10.1088/1361-648X/abeb44.   
224. Sch¨afer, T., N. Wentzell, F. Simkovic, Y.-Y. He, C. Hille, M. Klett, C. J. Eckhardt, B. Arzhang, ˇ V. Harkov, F. m. c.-M. Le R´egent, A. Kirsch, Y. Wang, et al., 2021, Phys. Rev. X 11, 011058, URL https://link.aps.org/doi/10.1103/PhysRevX.11.011058.   
225. Schneider, U., L. Hackerm¨uller, J. P. Ronzheimer, S. Will, S. Braun, T. Best, I. Bloch, E. Demler, S. Mandt, D. Rasch, and A. Rosch, 2012, Nature Physics 8(3), 213, ISSN 1745-2481, URL https://doi.org/10.1038/nphys2205.   
226. Schollw¨ock, U., 2011, Annals of Physics 326, 96.   
227. Schulz, H. J., 1990, Phys. Rev. Lett. 64, 1445, URL https://link.aps.org/doi/10.1103/ PhysRevLett.64.1445.   
228. S´en´echal, D., and A.-M. S. Tremblay, 2004, Phys. Rev. Lett. 92, 126401, URL https://link. aps.org/doi/10.1103/PhysRevLett.92.126401.   
229. Shen, K. M., F. Ronning, D. H. Lu, F. Baumberger, N. J. C. Ingle, W. S. Lee, W. Meevasana, Y. Kohsaka, M. Azuma, M. Takano, H. Takagi, and Z. X. Shen, 2005, Science 307(5711), 901.   
230. Shi, H., P. Rosenberg, S. Chiesa, and S. Zhang, 2016, Phys. Rev. Lett. 117, 040401, URL https://link.aps.org/doi/10.1103/PhysRevLett.117.040401.   
231. Shraiman, B. I., and E. D. Siggia, 1989, Phys. Rev. Lett. 62, 1564, URL https://link.aps. org/doi/10.1103/PhysRevLett.62.1564.   
232. Simons Collaboration on the Many-Electron Problem, M. Qin, C.-M. Chung, H. Shi, E. Vitali, C. Hubig, U. Schollw¨ock, S. R. White, and S. Zhang, 2020, Phys. Rev. X 10(3), 031016, publisher: American Physical Society, URL https://link.aps.org/doi/10.1103/PhysRevX. 10.031016.   
233. Singha, A., M. Gibertini, B. Karmakar, S. Yuan, M. Polini, G. Vignale, M. I. Katsnelson, A. Pinczuk, L. N. Pfeiffer, K. W. West, and V. Pellegrini, 2011, Science 332(6034), 1176, ISSN 0036-8075, URL https://science.sciencemag.org/content/332/6034/1176.   
234. Slater, J. C., 1951, Phys. Rev. 82, 538, URL https://link.aps.org/doi/10.1103/PhysRev. 82.538.   
235. Somma, R., G. Ortiz, J. E. Gubernatis, E. Knill, and R. Laflamme, 2002, Phys. Rev. A 65, 042323, URL https://link.aps.org/doi/10.1103/PhysRevA.65.042323.   
236. Sordi, G., P. S´emon, K. Haule, and A.-M. S. Tremblay, 2012, Phys. Rev. Lett. 108, 216401, URL https://link.aps.org/doi/10.1103/PhysRevLett.108.216401.   
237. Sorella, S., 2021, arXiv:2101.07045 [cond-mat] ArXiv: 2101.07045, URL http://arxiv.org/ abs/2101.07045.   
238. Sorella, S., G. B. Martins, F. Becca, C. Gazza, L. Capriotti, A. Parola, and E. Dagotto, 2002, Phys. Rev. Lett. 88(11), 117002, URL http://link.aps.org/doi/10.1103/PhysRevLett.88. 117002.   
239. Sorella, S., Y. Otsuka, and S. Yunoki, 2012, Scientific Reports 2(1), ISSN 2045-2322, URL http://dx.doi.org/10.1038/srep00992.   
240. Sorella, S., and E. Tosatti, 1992, Europhysics Letters (EPL) 19(8), 699, URL https://doi. org/10.1209%2F0295-5075%2F19%2F8%2F007.   
241. Stanescu, T. D., and G. Kotliar, 2006, Phys. Rev. B 74, 125110, URL https://link.aps. org/doi/10.1103/PhysRevB.74.125110.   
242. Staudt, R., Dzierzawa, M., and Muramatsu, A., 2000, Eur. Phys. J. B 17(3), 411, URL https://doi.org/10.1007/s100510070120.   
243. Stepanov, E. A., L. Peters, I. S. Krivenko, A. I. Lichtenstein, M. I. Katsnelson, and A. N. Rubtsov, 2018, npj Quantum Materials 3, 54.   
244. Szasz, A., J. Motruk, M. P. Zaletel, and J. E. Moore, 2020, Phys. Rev. X 10, 021042, URL https://link.aps.org/doi/10.1103/PhysRevX.10.021042.   
245. Taheridehkordi, A., S. H. Curnoe, and J. P. F. LeBlanc, 2020, Phys. Rev. B 102, 045115, URL https://link.aps.org/doi/10.1103/PhysRevB.102.045115.   
246. Taranto, C., S. Andergassen, J. Bauer, K. Held, A. Katanin, W. Metzner, G. Rohringer, and A. Toschi, 2014, Phys. Rev. Lett. 112, 196402, URL https://link.aps.org/doi/10.1103/ PhysRevLett.112.196402.   
247. Terletska, H., T. Chen, and E. Gull, 2017, Phys. Rev. B 95, 115149, URL https://link.aps. org/doi/10.1103/PhysRevB.95.115149.   
248. Terletska, H., T. Chen, J. Paki, and E. Gull, 2018, Phys. Rev. B 97, 115117, URL https: //link.aps.org/doi/10.1103/PhysRevB.97.115117.   
249. The Simons Collaboration on the Many-Electron Problem, C.-M. Chung, M. Qin, S. Zhang, U. Schollw¨ock, and S. R. White, 2020, Phys. Rev. B 102(4), 041106, publisher: American Physical Society, URL https://link.aps.org/doi/10.1103/PhysRevB.102.041106.   
250. Tocchio, L. F., F. Becca, and S. Sorella, 2016, Phys. Rev. B 94(19), 195126, URL https: //link.aps.org/doi/10.1103/PhysRevB.94.195126.   
251. Tocchio, L. F., A. Montorsi, and F. Becca, 2019, SciPost Physics 7(2), 021, ISSN 2542-4653, URL https://scipost.org/10.21468/SciPostPhys.7.2.021.   
252. Tocchio, L. F., A. Montorsi, and F. Becca, 2020, Phys. Rev. B 102(11), 115150, publisher: American Physical Society, URL https://link.aps.org/doi/10.1103/PhysRevB.102.115150.   
253. Tranquada, J. M., B. J. Sternlieb, J. D. Axe, Y. Nakamura, and S. Uchida, 1995, Nature 375(6532), 561, URL http://dx.doi.org/10.1038/375561a0.   
254. Tremblay, A.-M. S., B. Kyung, and D. S´en´echal, 2006, Low Temperature Physics 32(4), 424, URL https://doi.org/10.1063/1.2199446.   
255. Trivedi, N., and M. Randeria, 1995, Phys. Rev. Lett. 75, 312, URL https://link.aps.org/ doi/10.1103/PhysRevLett.75.312.   
256. Ulmke, M., R. T. Scalettar, A. Nazarenko, and E. Dagotto, 1996, Phys. Rev. B 54, 16523, URL https://link.aps.org/doi/10.1103/PhysRevB.54.16523.   
257. Van Damme, M., R. Vanhove, J. Haegeman, F. Verstraete, and L. Vanderstraeten, 2021, arXiv:2102.10982 [cond-mat, physics:quant-ph] URL http://arxiv.org/abs/2102.10982.   
258. Vanderstraeten, L., J. Haegeman, and F. Verstraete, 2019, Phys. Rev. B 99(16), 165121, ISSN 2469-9950, 2469-9969, URL https://link.aps.org/doi/10.1103/PhysRevB.99.165121.   
259. Varney, C. N., C.-R. Lee, Z. J. Bai, S. Chiesa, M. Jarrell, and R. T. Scalettar, 2009, Phys. Rev. B 80, 075116, URL https://link.aps.org/doi/10.1103/PhysRevB.80.075116.   
260. Vilardi, D., P. M. Bonetti, and W. Metzner, 2020, Phys. Rev. B 102(24), 245128.   
261. Vilardi, D., C. Taranto, and W. Metzner, 2019, Phys. Rev. B 99, 104501, URL https://link. aps.org/doi/10.1103/PhysRevB.99.104501.   
262. Vilk, Y. M., and A.-M. S. Tremblay, 1997, J. Phys. I France 7(11), 1309, URL http://dx. doi.org/10.1051/jp1:1997135.   
263. Vitali, E., H. Shi, M. Qin, and S. Zhang, 2016, Phys. Rev. B 94, 085140, URL https: //link.aps.org/doi/10.1103/PhysRevB.94.085140.   
264. Vojta, M., 2009, Advances in Physics 58(6), 699, ISSN 0001-8732, URL http://www. tandfonline.com/doi/abs/10.1080/00018730903122242.   
265. Simkovic, F., J. P. F. LeBlanc, A. J. Kim, Y. Deng, N. V. Prokof’ev, B. V. Svistunov, and ˇ E. Kozik, 2020, Phys. Rev. Lett. 124, 017003, URL https://link.aps.org/doi/10.1103/ PhysRevLett.124.017003.   
266. Simkovic, F., X.-W. Liu, Y. Deng, and E. Kozik, 2016, Phys. Rev. B ˇ 94, 085106, URL https://link.aps.org/doi/10.1103/PhysRevB.94.085106.   
267. Simkovic, I., Fedor, Y. Deng, and E. Kozik, 2019, arXiv e-prints , arXiv:1912.13054 ˇ 1912.13054.   
268. Wang, J., A. Eberlein, and W. Metzner, 2014, Phys. Rev. B 89, 121116, URL https://link. aps.org/doi/10.1103/PhysRevB.89.121116.   
269. Wang, W.-S., Y.-Y. Xiang, Q.-H. Wang, F. Wang, F. Yang, and D.-H. Lee, 2012, Phys. Rev. B 85, 035414, URL https://link.aps.org/doi/10.1103/PhysRevB.85.035414.   
270. Weber, C., T. Giamarchi, and C. M. Varma, 2014, Phys. Rev. Lett. 112(11), 117001, URL https://link.aps.org/doi/10.1103/PhysRevLett.112.117001.   
271. Weber, C., C. Yee, K. Haule, and G. Kotliar, 2012, EPL 100(3), 37001, ISSN 0295-5075, 1286-4854, URL https://iopscience.iop.org/article/10.1209/0295-5075/100/37001.   
272. Wecker, D., M. B. Hastings, N. Wiebe, B. K. Clark, C. Nayak, and M. Troyer, 2015, Phys. Rev. A 92, 062318, URL https://link.aps.org/doi/10.1103/PhysRevA.92.062318.   
273. White, I. G., R. G. Hulet, and K. R. A. Hazzard, 2019, Phys. Rev. A 100, 033612, URL https://link.aps.org/doi/10.1103/PhysRevA.100.033612.   
274. White, S. R., 1992, Phys. Rev. Lett. 69, 2863.   
275. White, S. R., and A. L. Chernyshev, 2007, Phys. Rev. Lett. 99, 127004, URL https://link. aps.org/doi/10.1103/PhysRevLett.99.127004.   
276. White, S. R., and D. J. Scalapino, 1998, Phys. Rev. Lett. 80(6), 1272, URL http://link. aps.org/doi/10.1103/PhysRevLett.80.1272.   
277. White, S. R., and D. J. Scalapino, 1998, Phys. Rev. Lett. 81(15), 3227, URL http://link. aps.org/doi/10.1103/PhysRevLett.81.3227.   
278. White, S. R., and D. J. Scalapino, 1999, Phys. Rev. B 60(2), R753, URL http://link.aps. org/doi/10.1103/PhysRevB.60.R753.   
279. White, S. R., and D. J. Scalapino, 2000, Phys. Rev. B 61(9), 6320, publisher: American Physical Society, URL https://link.aps.org/doi/10.1103/PhysRevB.61.6320.   
280. White, S. R., and D. J. Scalapino, 2003, Phys. Rev. Lett. 91(13), 136403, URL http://link. aps.org/doi/10.1103/PhysRevLett.91.136403.   
281. White, S. R., and D. J. Scalapino, 2009, Phys. Rev. B 79, 220504, URL http://link.aps. org/doi/10.1103/PhysRevB.79.220504.   
282. White, S. R., and D. J. Scalapino, 2015, Phys. Rev. B 92(20), 205112, URL https://link. aps.org/doi/10.1103/PhysRevB.92.205112.   
283. White, S. R., D. J. Scalapino, R. L. Sugar, N. E. Bickers, and R. T. Scalettar, 1989, Phys. Rev. B 39, 839, URL https://link.aps.org/doi/10.1103/PhysRevB.39.839.   
284. White, S. R., D. J. Scalapino, R. L. Sugar, E. Y. Loh, J. E. Gubernatis, and R. T. Scalettar, 1989, Phys. Rev. B 40, 506, URL https://link.aps.org/doi/10.1103/PhysRevB.40.506.   
285. Wietek, A., Y.-Y. He, S. R. White, A. Georges, and E. M. Stoudenmire, 2020, arXiv:2009.10736 [cond-mat] ArXiv: 2009.10736, URL http://arxiv.org/abs/2009.10736.   
286. Wietek, A., R. Rossi, F. Simkovic IV, M. Klett, P. Hansmann, M. Ferrero, E. M. Stouden- ˇ mire, T. Sch¨afer, and A. Georges, 2021, Mott insulating states with competing orders in the triangular lattice Hubbard model, 2102.12904, URL https://arxiv.org/abs/2102.12904.   
287. Wu, W., M. Ferrero, A. Georges, and E. Kozik, 2017, Phys. Rev. B 96, 041105, URL https: //link.aps.org/doi/10.1103/PhysRevB.96.041105.   
288. Wu, W., M. S. Scheurer, S. Chatterjee, S. Sachdev, A. Georges, and M. Ferrero, 2018, Phys. Rev. X 8, 021048, URL https://link.aps.org/doi/10.1103/PhysRevX.8.021048.   
289. Wu, W., M. S. Scheurer, M. Ferrero, and A. Georges, 2020, Phys. Rev. Research 2, 033067, URL https://link.aps.org/doi/10.1103/PhysRevResearch.2.033067.   
290. Yamase, H., A. Eberlein, and W. Metzner, 2016, Phys. Rev. Lett. 116, 096402, URL https: //link.aps.org/doi/10.1103/PhysRevLett.116.096402.   
291. Yanagisawa, T., S. Koike, and K. Yamaji, 2001, Phys. Rev. B 64(18), 184509, publisher: American Physical Society, URL https://link.aps.org/doi/10.1103/PhysRevB.64.184509.   
292. Yanagisawa, T., M. Miyazaki, and K. Yamaji, 2009, J. Phys. Soc. Jpn. 78(1), 013706, ISSN 0031-9015, 1347-4073, URL http://journals.jps.jp/doi/10.1143/JPSJ.78.013706.   
293. Yang, C., and A. E. Feiguin, 2016, Phys. Rev. B 93(8), 081107, URL https://link.aps.org/ doi/10.1103/PhysRevB.93.081107.   
294. Yokoyama, H., and H. Shiba, 1988, J. Phys. Soc. Jpn. 57(7), 2482, ISSN 0031-9015, publisher: The Physical Society of Japan, URL https://journals.jps.jp/doi/10.1143/JPSJ.57.2482.   
295. Zaanen, J., and O. Gunnarsson, 1989, Phys. Rev. B 40(10), 7391, URL http://link.aps. org/doi/10.1103/PhysRevB.40.7391.   
296. Zanchi, D., and H. J. Schulz, 2000, Phys. Rev. B 61, 13609, URL https://link.aps.org/ doi/10.1103/PhysRevB.61.13609.   
297. Zegrodnik, M., A. Biborski, M. Fidrysiak, and J. Spa lek, 2019, Phys. Rev. B 99(10), 104511, URL https://link.aps.org/doi/10.1103/PhysRevB.99.104511.   
298. Zegrodnik, M., A. Biborski, M. Fidrysiak, and J. Spa lek, 2020, arXiv:2009.04922 [cond-mat] ArXiv: 2009.04922, URL http://arxiv.org/abs/2009.04922.   
299. Zhang, F. C., and T. M. Rice, 1988, Phys. Rev. B 37(7), 3759.   
300. Zhang, S., J. Carlson, and J. E. Gubernatis, 1997, Phys. Rev. B 55, 7464, URL https: //link.aps.org/doi/10.1103/PhysRevB.55.7464.   
301. Zhang, Y. Z., and M. Imada, 2007, Phys. Rev. B 76, 045108, URL https://link.aps.org/ doi/10.1103/PhysRevB.76.045108.   
302. Zheng, B.-X., and G. K.-L. Chan, 2016, Phys. Rev. B 93(3), 035126, URL https://link. aps.org/doi/10.1103/PhysRevB.93.035126.   
303. Zheng, B.-X., C.-M. Chung, P. Corboz, G. Ehlers, M.-P. Qin, R. M. Noack, H. Shi, S. R. White, S. Zhang, and G. K.-L. Chan, 2017, Science 358(6367), 1155, ISSN 0036-8075, 1095- 9203, URL http://science.sciencemag.org/content/358/6367/1155.   
304. Zheng, H., H. J. Changlani, K. T. Williams, B. Busemeyer, and L. K. Wagner, 2018, Frontiers in Physics 6, 43, ISSN 2296-424X, URL https://www.frontiersin.org/article/10.3389/ fphy.2018.00043.